/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.evrete.api.Action;
import org.evrete.api.ActiveField;
import org.evrete.api.FactHandle;
import org.evrete.api.Knowledge;
import org.evrete.api.MemoryFactory;
import org.evrete.api.RuleSession;
import org.evrete.api.RuntimeRule;
import org.evrete.api.Type;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.runtime.MemoryActionCounter;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.TypeMemoryState;
import org.evrete.runtime.evaluation.AlphaBucketMeta;

abstract class AbstractWorkingMemory<S extends RuleSession<S>>
extends AbstractRuntime<RuntimeRule, S>
implements RuleSession<S> {
    private static final Logger LOGGER = Logger.getLogger(AbstractWorkingMemory.class.getName());
    final KnowledgeRuntime knowledge;
    final SessionMemory memory;
    final MemoryActionCounter actionCounter;
    private boolean active = true;
    private final boolean warnUnknownTypes;

    AbstractWorkingMemory(KnowledgeRuntime knowledge) {
        super(knowledge);
        this.knowledge = knowledge;
        this.actionCounter = new MemoryActionCounter();
        MemoryFactory memoryFactory = knowledge.getService().getMemoryFactoryProvider().instance(this);
        this.memory = new SessionMemory(knowledge.getConfiguration(), memoryFactory);
        this.warnUnknownTypes = knowledge.getConfiguration().getAsBoolean("evrete.core.warn-unknown-types");
    }

    void invalidateSession() {
        this.active = false;
    }

    public Knowledge getParentContext() {
        return this.knowledge;
    }

    private void _assertActive() {
        if (!this.active) {
            throw new IllegalStateException("Session has been closed");
        }
    }

    public final SessionMemory getMemory() {
        return this.memory;
    }

    @Override
    public final FactHandle insert(Object fact) {
        this._assertActive();
        return this.insert(this.getTypeResolver().resolve(fact), fact);
    }

    @Override
    public final FactHandle insert(String type, Object fact) {
        this._assertActive();
        return this.insert(this.getTypeResolver().getType(type), fact);
    }

    @Override
    public Object getFact(FactHandle handle) {
        return this.memory.get(handle.getTypeId()).getFact(handle);
    }

    private FactHandle insert(Type<?> type, Object fact) {
        if (fact == null) {
            throw new NullPointerException("Null facts are not supported");
        }
        if (type == null) {
            if (this.warnUnknownTypes) {
                LOGGER.warning("Can not resolve type for " + fact + ", insert operation skipped.");
            }
            return null;
        }
        return this.memory.get(type).externalInsert(fact, this.actionCounter);
    }

    @Override
    public final void update(FactHandle handle, Object newValue) {
        this._assertActive();
        if (handle == null) {
            throw new NullPointerException("Null handle provided during update");
        }
        this.memory.get(handle.getTypeId()).add(Action.UPDATE, handle, new FactRecord(newValue), this.actionCounter);
    }

    @Override
    public final void delete(FactHandle handle) {
        this._assertActive();
        this.memory.get(handle.getTypeId()).add(Action.RETRACT, handle, null, this.actionCounter);
    }

    @Override
    public final void forEachFact(BiConsumer<FactHandle, Object> consumer) {
        for (TypeMemory tm : this.memory) {
            tm.forEachFact(consumer);
        }
    }

    @Override
    protected void onNewActiveField(TypeMemoryState state, ActiveField newField) {
        this.memory.onNewActiveField(state);
    }

    @Override
    public final void onNewAlphaBucket(TypeMemoryState newState, FieldsKey key, AlphaBucketMeta meta) {
        this.memory.onNewAlphaBucket(newState, key, meta);
    }

    @Override
    public void clear() {
        this.memory.clear();
    }
}

