/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.api.FactHandleVersioned;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.api.Type;
import org.evrete.collections.JoinReIterator;
import org.evrete.runtime.AbstractBetaConditionNode;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.BetaConditionNode;
import org.evrete.runtime.BetaEntryNode;
import org.evrete.runtime.BetaMemoryNode;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.EntryNodeDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.NodeDescriptor;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.SessionMemory;

public class BetaEndNode
extends BetaConditionNode
implements RhsFactGroup {
    private final FactType[] entryNodes;

    BetaEndNode(RuntimeRuleImpl rule, ConditionNodeDescriptor nodeDescriptor, boolean singleGroup) {
        super(rule, nodeDescriptor, BetaEndNode.create(nodeDescriptor.getSources(), rule));
        this.entryNodes = nodeDescriptor.getTypes();
        this.setMergeToMain(!singleGroup);
    }

    private static BetaMemoryNode create(RuntimeRuleImpl rule, NodeDescriptor desc) {
        if (desc.isConditionNode()) {
            return new BetaConditionNode(rule, (ConditionNodeDescriptor)desc, BetaEndNode.create(desc.getSources(), rule));
        }
        EntryNodeDescriptor descriptor = (EntryNodeDescriptor)desc;
        return new BetaEntryNode((AbstractRuleSession<?>)rule.getRuntime(), descriptor);
    }

    private static BetaMemoryNode[] create(NodeDescriptor[] sources, RuntimeRuleImpl rule) {
        BetaMemoryNode[] result = new BetaMemoryNode[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            result[i] = BetaEndNode.create(rule, sources[i]);
        }
        return result;
    }

    @Override
    public ReIterator<MemoryKey> keyIterator(boolean delta) {
        return delta ? JoinReIterator.of((ReIterator[])new ReIterator[]{this.iterator(KeyMode.UNKNOWN_UNKNOWN), this.iterator(KeyMode.KNOWN_UNKNOWN)}) : this.iterator(KeyMode.MAIN);
    }

    @Override
    public ReIterator<FactHandleVersioned> factIterator(FactType type, MemoryKey key) {
        KeyMode mode = KeyMode.values()[key.getMetaValue()];
        SessionMemory memory = this.getRuntime().memory;
        return memory.get(type.getType()).get(type.getFields()).get(type.getAlphaMask()).values(mode, key);
    }

    @Override
    public FactType[] types() {
        return this.entryNodes;
    }

    boolean dependsOn(Type<?> type) {
        return this.getDescriptor().getTypeMask().get(type.getId());
    }

    @Override
    public void commitDelta() {
        this.forEachConditionNode(AbstractBetaConditionNode::commitDelta1);
    }
}

