/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.api.ActiveField;
import org.evrete.api.TypeField;
import org.evrete.runtime.FactType;

public final class BetaFieldReference {
    private final FactType factType;
    private final int fieldIndex;
    private final ActiveField activeField;

    public BetaFieldReference(FactType factType, TypeField field) {
        this.factType = factType;
        this.fieldIndex = factType.findFieldPosition(field);
        this.activeField = factType.getFields().getFields()[this.fieldIndex];
    }

    public FactType getFactType() {
        return this.factType;
    }

    int getFieldIndex() {
        return this.fieldIndex;
    }

    public ActiveField getActiveField() {
        return this.activeField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetaFieldReference that = (BetaFieldReference)o;
        return this.fieldIndex == that.fieldIndex && this.factType.equals(that.factType);
    }

    public int hashCode() {
        return this.factType.hashCode() * 31 + this.fieldIndex;
    }
}

