/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.evrete.api.ActiveField;
import org.evrete.api.NamedType;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.runtime.ActiveFieldImpl;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.evaluation.AlphaBucketMeta;

public class FactType
implements NamedType {
    public static final FactType[] ZERO_ARRAY = new FactType[0];
    private static final Comparator<FactType> COMPARATOR = Comparator.comparingInt(FactType::getInRuleIndex);
    private final String var;
    private final AlphaBucketMeta alphaMask;
    private final FieldsKey fields;
    private final int inRuleIndex;

    FactType(String var, AlphaBucketMeta alphaMask, FieldsKey fields, int inRuleIndex) {
        this.var = var;
        this.alphaMask = alphaMask;
        this.fields = fields;
        this.inRuleIndex = inRuleIndex;
    }

    public static FactType[] toArray(Collection<FactType> set) {
        FactType[] arr = set.toArray(ZERO_ARRAY);
        Arrays.sort(arr, COMPARATOR);
        return arr;
    }

    int findFieldPosition(TypeField field) {
        ActiveField[] arr = this.fields.getFields();
        for (int i = 0; i < arr.length; ++i) {
            ActiveFieldImpl f = (ActiveFieldImpl)arr[i];
            if (!f.getDelegate().equals(field)) continue;
            return i;
        }
        throw new IllegalStateException("Field not found");
    }

    public FieldsKey getFields() {
        return this.fields;
    }

    AlphaBucketMeta getAlphaMask() {
        return this.alphaMask;
    }

    @Override
    public String getVar() {
        return this.var;
    }

    @Override
    public Type<?> getType() {
        return this.fields.getType();
    }

    public int getInRuleIndex() {
        return this.inRuleIndex;
    }

    public String toString() {
        return "{var='" + this.var + '\'' + ", type='" + this.fields.getType().getName() + "'}";
    }
}

