/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evrete.api.Copyable;
import org.evrete.api.RuleScope;

public class Imports
implements Copyable<Imports> {
    private final EnumMap<RuleScope, Set<String>> imports = new EnumMap(RuleScope.class);

    public Imports() {
        for (RuleScope scope : RuleScope.values()) {
            this.imports.put(scope, new HashSet());
        }
    }

    private Imports(Imports parent) {
        this();
        this.append(parent);
    }

    public void append(Imports parent) {
        for (Map.Entry<RuleScope, Set<String>> entry : parent.imports.entrySet()) {
            this.imports.get((Object)entry.getKey()).addAll((Collection<String>)entry.getValue());
        }
    }

    public void add(RuleScope scope, String imp) {
        String s;
        if (imp == null || (s = imp.trim()).isEmpty()) {
            return;
        }
        s = s.replaceAll(";", "");
        s = s.replaceAll("\\s{2,}]", " ");
        this.imports.get((Object)scope).add(s);
    }

    public Set<String> get(RuleScope ... scopes) {
        HashSet<String> set = new HashSet<String>();
        if (scopes != null) {
            for (RuleScope scope : scopes) {
                set.addAll((Collection<String>)this.imports.get((Object)scope));
            }
        }
        return set;
    }

    @Override
    public Imports copyOf() {
        return new Imports(this);
    }
}

