/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.StringJoiner;
import java.util.function.Consumer;
import org.evrete.api.InnerFactMemory;
import org.evrete.api.KeyedFactStorage;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.KeyMemoryBucket;
import org.evrete.runtime.MemoryComponent;
import org.evrete.runtime.evaluation.AlphaBucketMeta;

public class KeyMemory
extends MemoryComponent
implements InnerFactMemory {
    private final FieldsKey typeFields;
    private final ArrayOf<KeyMemoryBucket> alphaBuckets;

    KeyMemory(MemoryComponent runtime, FieldsKey typeFields) {
        super(runtime);
        this.typeFields = typeFields;
        this.alphaBuckets = new ArrayOf<KeyMemoryBucket>(KeyMemoryBucket.class);
    }

    @Override
    protected void clearLocalData() {
    }

    void forEachBucket(Consumer<? super KeyMemoryBucket> consumer) {
        this.alphaBuckets.forEach(consumer);
    }

    public KeyedFactStorage get(AlphaBucketMeta mask) {
        int bucketIndex = mask.getBucketIndex();
        if (bucketIndex >= ((KeyMemoryBucket[])this.alphaBuckets.data).length) {
            throw new IllegalArgumentException("No alpha bucket created for " + mask);
        }
        KeyedFactStorage storage = ((KeyMemoryBucket[])this.alphaBuckets.data)[bucketIndex].getFieldData();
        if (storage == null) {
            throw new IllegalArgumentException("No alpha bucket created for " + mask);
        }
        return storage;
    }

    @Override
    public void commitChanges() {
        for (KeyMemoryBucket bucket : (KeyMemoryBucket[])this.alphaBuckets.data) {
            bucket.commitChanges();
        }
    }

    KeyMemoryBucket getCreate(AlphaBucketMeta alphaMeta) {
        return this.alphaBuckets.computeIfAbsent(alphaMeta.getBucketIndex(), k -> KeyMemoryBucket.factory(this, this.typeFields, alphaMeta));
    }

    public String toString() {
        StringJoiner sj = new StringJoiner("\n");
        this.alphaBuckets.forEach(bucket -> sj.add(bucket.toString()));
        return sj.toString();
    }
}

