/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.LinkedList;
import org.evrete.api.ActiveField;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.KeyedFactStorage;
import org.evrete.api.ValueHandle;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.MemoryComponent;
import org.evrete.runtime.RuntimeFact;
import org.evrete.runtime.evaluation.AlphaBucketMeta;

abstract class KeyMemoryBucket
extends MemoryComponent {
    static final RuntimeFact DUMMY_FACT = new RuntimeFact(){

        @Override
        boolean sameValues(RuntimeFact other) {
            return false;
        }
    };
    final KeyedFactStorage fieldData;
    final ActiveField[] activeFields;
    final Collection<FactHandleVersioned> insertData = new LinkedList<FactHandleVersioned>();
    RuntimeFact current = null;

    KeyMemoryBucket(MemoryComponent runtime, FieldsKey typeFields) {
        super(runtime);
        this.fieldData = this.memoryFactory.newBetaStorage(typeFields.getFields());
        this.activeFields = typeFields.getFields();
    }

    static KeyMemoryBucket factory(MemoryComponent runtime, FieldsKey typeFields, AlphaBucketMeta alphaMask) {
        if (alphaMask.isEmpty()) {
            switch (typeFields.size()) {
                case 0: {
                    return new KeyMemoryBucketNoAlpha.KeyMemoryBucketNoAlpha0(runtime, typeFields);
                }
                case 1: {
                    return new KeyMemoryBucketNoAlpha.KeyMemoryBucketNoAlpha1(runtime, typeFields);
                }
            }
            return new KeyMemoryBucketNoAlpha.KeyMemoryBucketNoAlphaN(runtime, typeFields);
        }
        switch (typeFields.size()) {
            case 0: {
                return new KeyMemoryBucketAlpha.KeyMemoryBucketAlpha0(runtime, typeFields, alphaMask);
            }
            case 1: {
                return new KeyMemoryBucketAlpha.KeyMemoryBucketAlpha1(runtime, typeFields, alphaMask);
            }
        }
        return new KeyMemoryBucketAlpha.KeyMemoryBucketAlphaN(runtime, typeFields, alphaMask);
    }

    ValueHandle currentFactField(ActiveField field) {
        return this.current.getValue(field);
    }

    abstract void flushBuffer();

    abstract void insert(Iterable<RuntimeFact> var1);

    @Override
    protected final void clearLocalData() {
        this.fieldData.clear();
    }

    final KeyedFactStorage getFieldData() {
        return this.fieldData;
    }

    @Override
    public final void commitChanges() {
        this.fieldData.commitChanges();
    }

    public final String toString() {
        return this.fieldData.toString();
    }

    static abstract class KeyMemoryBucketNoAlpha
    extends KeyMemoryBucket {
        KeyMemoryBucketNoAlpha(MemoryComponent runtime, FieldsKey typeFields) {
            super(runtime, typeFields);
        }

        @Override
        final void insert(Iterable<RuntimeFact> facts) {
            this.current = DUMMY_FACT;
            for (RuntimeFact fact : facts) {
                if (this.current.sameValues(fact)) {
                    this.insertData.add(fact.factHandle);
                    continue;
                }
                this.flushBuffer();
                this.insertData.add(fact.factHandle);
                this.current = fact;
            }
            if (!this.insertData.isEmpty()) {
                this.flushBuffer();
            }
        }

        static class KeyMemoryBucketNoAlphaN
        extends KeyMemoryBucketNoAlpha {
            KeyMemoryBucketNoAlphaN(MemoryComponent runtime, FieldsKey typeFields) {
                super(runtime, typeFields);
            }

            @Override
            final void flushBuffer() {
                if (this.current != DUMMY_FACT) {
                    for (ActiveField field : this.activeFields) {
                        this.fieldData.write(this.currentFactField(field));
                    }
                    this.fieldData.write(this.insertData);
                    this.insertData.clear();
                }
            }
        }

        static class KeyMemoryBucketNoAlpha1
        extends KeyMemoryBucketNoAlpha {
            private final ActiveField field;

            KeyMemoryBucketNoAlpha1(MemoryComponent runtime, FieldsKey typeFields) {
                super(runtime, typeFields);
                assert (typeFields.size() == 1);
                this.field = typeFields.getFields()[0];
            }

            @Override
            final void flushBuffer() {
                if (this.current != DUMMY_FACT) {
                    this.fieldData.write(this.currentFactField(this.field));
                    this.fieldData.write(this.insertData);
                    this.insertData.clear();
                }
            }
        }

        static class KeyMemoryBucketNoAlpha0
        extends KeyMemoryBucketNoAlpha {
            KeyMemoryBucketNoAlpha0(MemoryComponent runtime, FieldsKey typeFields) {
                super(runtime, typeFields);
            }

            @Override
            final void flushBuffer() {
                if (this.current != DUMMY_FACT) {
                    this.fieldData.write(this.insertData);
                    this.insertData.clear();
                }
            }
        }
    }

    static abstract class KeyMemoryBucketAlpha
    extends KeyMemoryBucket {
        private final AlphaBucketMeta alphaMask;

        KeyMemoryBucketAlpha(MemoryComponent runtime, FieldsKey typeFields, AlphaBucketMeta alphaMask) {
            super(runtime, typeFields);
            this.alphaMask = alphaMask;
        }

        @Override
        final void insert(Iterable<RuntimeFact> facts) {
            this.current = DUMMY_FACT;
            for (RuntimeFact fact : facts) {
                if (!this.alphaMask.test(fact.alphaTests)) continue;
                if (this.current.sameValues(fact)) {
                    this.insertData.add(fact.factHandle);
                    continue;
                }
                this.flushBuffer();
                this.insertData.add(fact.factHandle);
                this.current = fact;
            }
            if (!this.insertData.isEmpty()) {
                this.flushBuffer();
            }
        }

        static class KeyMemoryBucketAlphaN
        extends KeyMemoryBucketAlpha {
            KeyMemoryBucketAlphaN(MemoryComponent runtime, FieldsKey typeFields, AlphaBucketMeta alphaMask) {
                super(runtime, typeFields, alphaMask);
            }

            @Override
            final void flushBuffer() {
                if (this.current != DUMMY_FACT) {
                    for (ActiveField field : this.activeFields) {
                        this.fieldData.write(this.currentFactField(field));
                    }
                    this.fieldData.write(this.insertData);
                    this.insertData.clear();
                }
            }
        }

        static class KeyMemoryBucketAlpha1
        extends KeyMemoryBucketAlpha {
            private final ActiveField field;

            KeyMemoryBucketAlpha1(MemoryComponent runtime, FieldsKey typeFields, AlphaBucketMeta alphaMask) {
                super(runtime, typeFields, alphaMask);
                assert (typeFields.size() == 1);
                this.field = typeFields.getFields()[0];
            }

            @Override
            final void flushBuffer() {
                if (this.current != DUMMY_FACT) {
                    this.fieldData.write(this.currentFactField(this.field));
                    this.fieldData.write(this.insertData);
                    this.insertData.clear();
                }
            }
        }

        static class KeyMemoryBucketAlpha0
        extends KeyMemoryBucketAlpha {
            KeyMemoryBucketAlpha0(MemoryComponent runtime, FieldsKey typeFields, AlphaBucketMeta alphaMask) {
                super(runtime, typeFields, alphaMask);
            }

            @Override
            final void flushBuffer() {
                if (this.current != DUMMY_FACT) {
                    this.fieldData.write(this.insertData);
                    this.insertData.clear();
                }
            }
        }
    }
}

