/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.evrete.KnowledgeService;
import org.evrete.api.ActiveField;
import org.evrete.api.EvaluationListener;
import org.evrete.api.Knowledge;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuleScope;
import org.evrete.api.RuleSession;
import org.evrete.api.StatefulSession;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.StatefulSessionImpl;
import org.evrete.runtime.TypeMemoryState;
import org.evrete.runtime.evaluation.AlphaBucketMeta;

public class KnowledgeRuntime
extends AbstractRuntime<RuleDescriptor, Knowledge>
implements Knowledge {
    private final WeakHashMap<RuleSession<?>, Object> sessions = new WeakHashMap();
    private final Object VALUE = new Object();
    private final Set<EvaluationListener> evaluationListeners = new HashSet<EvaluationListener>();
    private final List<RuleDescriptor> ruleDescriptors = new ArrayList<RuleDescriptor>();

    public KnowledgeRuntime(KnowledgeService service) {
        super(service);
    }

    @Override
    protected void onNewActiveField(TypeMemoryState newState, ActiveField newField) {
    }

    @Override
    public void onNewAlphaBucket(TypeMemoryState newState, FieldsKey key, AlphaBucketMeta meta) {
    }

    @Override
    public RuleDescriptor compileRule(RuleBuilder<?> builder) {
        RuleDescriptor rd = super.compileRuleBuilder(builder);
        this.ruleDescriptors.add(rd);
        return rd;
    }

    @Override
    public List<RuleDescriptor> getRules() {
        return this.ruleDescriptors;
    }

    @Override
    public void addListener(EvaluationListener listener) {
        this.evaluationListeners.add(listener);
    }

    @Override
    public Knowledge addImport(RuleScope scope, String imp) {
        return (Knowledge)super.addImport(scope, imp);
    }

    @Override
    public Knowledge addImport(RuleScope scope, Class<?> type) {
        super.addImport(scope, type);
        return this;
    }

    @Override
    public Knowledge appendDslRules(String dsl, InputStream ... streams) throws IOException {
        this.append(dsl, streams);
        return this;
    }

    @Override
    public Knowledge appendDslRules(String dsl, URL ... resources) throws IOException {
        this.append(dsl, resources);
        return this;
    }

    @Override
    public Knowledge appendDslRules(String dsl, Reader ... readers) throws IOException {
        this.append(dsl, readers);
        return this;
    }

    @Override
    public Knowledge appendDslRules(String dsl, Class<?> classes) throws IOException {
        this.append(dsl, classes);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(RuleSession<?> session) {
        WeakHashMap<RuleSession<?>, Object> weakHashMap = this.sessions;
        synchronized (weakHashMap) {
            this.sessions.remove(session);
        }
    }

    @Override
    public Collection<RuleSession<?>> getSessions() {
        return Collections.unmodifiableCollection(this.sessions.keySet());
    }

    @Override
    public StatefulSession createSession() {
        StatefulSessionImpl session = new StatefulSessionImpl(this);
        this.sessions.put(session, this.VALUE);
        for (EvaluationListener listener : this.evaluationListeners) {
            session.addListener(listener);
        }
        return session;
    }

    @Override
    public void removeListener(EvaluationListener listener) {
        this.evaluationListeners.remove(listener);
    }
}

