/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Iterator;
import java.util.function.BiPredicate;
import java.util.logging.Logger;
import org.evrete.api.Action;
import org.evrete.api.FactHandle;
import org.evrete.collections.LinearHashSet;
import org.evrete.runtime.AtomicMemoryAction;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.MemoryActionListener;

class MemoryActionBuffer {
    private static final Logger LOGGER = Logger.getLogger(MemoryActionBuffer.class.getName());
    private static final BiPredicate<AtomicMemoryAction, FactHandle> SEARCH_FUNCTION = (existing, factHandle) -> existing.handle.equals(factHandle);
    private final LinearHashSet<AtomicMemoryAction> queue;

    MemoryActionBuffer(int minCapacity) {
        this.queue = new LinearHashSet(minCapacity);
    }

    AtomicMemoryAction get(FactHandle factHandle) {
        int hash = factHandle.hashCode();
        int addr = this.queue.findBinIndex((AtomicMemoryAction)((Object)factHandle), hash, SEARCH_FUNCTION);
        return (AtomicMemoryAction)this.queue.get(addr);
    }

    void add(Action action, FactHandle factHandle, FactRecord factRecord, MemoryActionListener listener) {
        this.queue.resize();
        int hash = factHandle.hashCode();
        int addr = this.queue.findBinIndex((AtomicMemoryAction)((Object)factHandle), hash, SEARCH_FUNCTION);
        AtomicMemoryAction existingAction = (AtomicMemoryAction)this.queue.get(addr);
        if (existingAction == null) {
            this.queue.saveDirect(new AtomicMemoryAction(action, factHandle, factRecord), addr);
            listener.apply(action, true);
        } else {
            switch (action) {
                case INSERT: {
                    LOGGER.warning("Fact has been already inserted, operation skipped.");
                    break;
                }
                case UPDATE: {
                    switch (existingAction.action) {
                        case RETRACT: {
                            LOGGER.warning("An attempt was made to update a fact that has been just deleted, update operation skipped");
                            break;
                        }
                        case INSERT: 
                        case UPDATE: {
                            existingAction.factRecord = factRecord;
                        }
                    }
                    break;
                }
                case RETRACT: {
                    switch (existingAction.action) {
                        case RETRACT: {
                            break;
                        }
                        case INSERT: {
                            existingAction.action = Action.RETRACT;
                            listener.apply(Action.INSERT, false);
                            listener.apply(Action.RETRACT, true);
                            break;
                        }
                        case UPDATE: {
                            existingAction.action = Action.RETRACT;
                            listener.apply(Action.UPDATE, false);
                            listener.apply(Action.RETRACT, true);
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    Iterator<AtomicMemoryAction> actions() {
        return this.queue.iterator();
    }

    void clear() {
        this.queue.clear();
    }

    public String toString() {
        return "{queue=" + this.queue + '}';
    }
}

