/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import org.evrete.api.Action;
import org.evrete.runtime.MemoryActionListener;

class MemoryActionCounter
implements MemoryActionListener {
    private final int[] actionCounts = new int[Action.values().length];
    private int totalActions = 0;

    MemoryActionCounter() {
    }

    boolean hasData() {
        return this.totalActions > 0;
    }

    int deltaOperations() {
        return this.actionCounts[Action.INSERT.ordinal()] + this.actionCounts[Action.UPDATE.ordinal()];
    }

    @Override
    public void apply(Action action, boolean flag) {
        int delta = flag ? 1 : -1;
        this.totalActions += delta;
        int n = action.ordinal();
        this.actionCounts[n] = this.actionCounts[n] + delta;
    }

    void clear() {
        Arrays.fill(this.actionCounts, 0);
        this.totalActions = 0;
    }

    public String toString() {
        return "{actions=" + Arrays.toString(this.actionCounts) + ", total=" + this.totalActions + '}';
    }
}

