/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.Configuration;
import org.evrete.api.MemoryFactory;
import org.evrete.api.ValueResolver;
import org.evrete.collections.ArrayOf;

abstract class MemoryComponent {
    final MemoryFactory memoryFactory;
    final Configuration configuration;
    final ValueResolver valueResolver;
    private final ArrayOf<MemoryComponent> childComponents = new ArrayOf<MemoryComponent>(MemoryComponent.class);

    MemoryComponent(MemoryFactory memoryFactory, Configuration configuration) {
        this.memoryFactory = memoryFactory;
        this.configuration = configuration;
        this.valueResolver = memoryFactory.getValueResolver();
    }

    MemoryComponent(MemoryComponent parent) {
        this.memoryFactory = parent.memoryFactory;
        this.configuration = parent.configuration;
        this.valueResolver = parent.valueResolver;
        parent.addChild(this);
    }

    abstract void commitChanges();

    private void addChild(MemoryComponent childComponent) {
        this.childComponents.append(childComponent);
    }

    MemoryComponent[] childComponents() {
        return (MemoryComponent[])this.childComponents.data;
    }

    protected abstract void clearLocalData();

    public final void clear() {
        this.clearLocalData();
        for (MemoryComponent child : (MemoryComponent[])this.childComponents.data) {
            child.clear();
        }
    }
}

