/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.api.FactHandle;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.TypeMemory;

class RhsFactType {
    private final FactType type;
    private final RhsFactGroup group;
    private final TypeMemory typeMemory;
    FactHandle handle;
    Object value;
    ReIterator<FactHandleVersioned> factIterator;
    private MemoryKey currentKey;
    private FactHandleVersioned currentFactHandle;

    RhsFactType(SessionMemory memory, FactType type, RhsFactGroup group) {
        this.type = type;
        this.group = group;
        this.typeMemory = memory.get(type.getType().getId());
    }

    void resetState() {
        this.currentFactHandle = null;
        this.currentKey = null;
    }

    void setCurrentKey(MemoryKey key) {
        if (key != this.currentKey) {
            this.currentKey = key;
            this.factIterator = this.group.factIterator(this.type, key);
            this.currentFactHandle = null;
        }
    }

    boolean setCurrentFact(FactHandleVersioned v) {
        if (v == this.currentFactHandle) {
            return true;
        }
        FactHandle handle = v.getHandle();
        FactRecord fact = this.typeMemory.getStoredRecord(handle);
        if (fact == null || fact.getVersion() != v.getVersion()) {
            return false;
        }
        this.currentFactHandle = v;
        this.handle = handle;
        this.value = fact.instance;
        return true;
    }

    public String toString() {
        return this.currentKey.toString();
    }
}

