/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.Objects;
import org.evrete.api.ActiveField;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.FieldToValue;
import org.evrete.api.ValueHandle;
import org.evrete.api.ValueResolver;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.TypeMemoryState;
import org.evrete.runtime.evaluation.AlphaEvaluator;
import org.evrete.util.Bits;

class RuntimeFact {
    private static final Bits EMPTY = new Bits();
    final Object[] fieldValues;
    final ValueHandle[] valueHandles;
    final FactHandleVersioned factHandle;
    final Bits alphaTests;
    final ValueResolver resolver;

    RuntimeFact() {
        this.fieldValues = null;
        this.factHandle = null;
        this.alphaTests = null;
        this.valueHandles = null;
        this.resolver = null;
    }

    RuntimeFact(ValueResolver resolver, TypeMemoryState typeMemoryState, FactHandleVersioned factHandle, FactRecord factRecord) {
        this.factHandle = factHandle;
        this.resolver = resolver;
        ActiveField[] activeFields = typeMemoryState.activeFields;
        this.fieldValues = new Object[activeFields.length];
        this.valueHandles = new ValueHandle[activeFields.length];
        for (int i = 0; i < this.fieldValues.length; ++i) {
            this.fieldValues[i] = activeFields[i].readValue(factRecord.instance);
        }
        AlphaEvaluator[] alphaEvaluators = typeMemoryState.alphaEvaluators;
        if (alphaEvaluators.length == 0) {
            this.alphaTests = EMPTY;
        } else {
            FieldToValue func = field -> this.fieldValues[field.getValueIndex()];
            this.alphaTests = new Bits();
            for (AlphaEvaluator alphaEvaluator : alphaEvaluators) {
                if (!alphaEvaluator.test(func)) continue;
                this.alphaTests.set(alphaEvaluator.getIndex());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ValueHandle getValue(ActiveField field) {
        int idx = field.getValueIndex();
        ValueHandle h = this.valueHandles[idx];
        if (h != null) return h;
        ValueHandle[] valueHandleArray = this.valueHandles;
        synchronized (this.valueHandles) {
            h = this.valueHandles[idx];
            if (h != null) return h;
            this.valueHandles[idx] = h = this.resolver.getValueHandle(field.getValueType(), this.fieldValues[idx]);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return h;
        }
    }

    boolean sameValues(RuntimeFact other) {
        if (other == null) {
            return false;
        }
        for (int i = 0; i < this.fieldValues.length; ++i) {
            if (Objects.equals(this.fieldValues[i], other.fieldValues[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "{handle=" + this.factHandle.getHandle() + ", values=" + Arrays.toString(this.fieldValues) + '}';
    }
}

