/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.evrete.api.ActiveField;
import org.evrete.api.Copyable;
import org.evrete.api.ExpressionResolver;
import org.evrete.api.FieldReference;
import org.evrete.api.RuleScope;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.ActiveFieldImpl;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.Imports;
import org.evrete.runtime.TypeMemoryState;
import org.evrete.runtime.builder.FactTypeBuilder;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.evaluation.AlphaEvaluator;
import org.evrete.runtime.evaluation.EvaluatorWrapper;

abstract class RuntimeMetaData<C extends RuntimeContext<C>>
implements RuntimeContext<C> {
    private static final Comparator<ActiveField> DEFAULT_FIELD_COMPARATOR = Comparator.comparing(ActiveField::getValueIndex);
    private final Imports imports;
    private final Map<String, Object> properties;
    private final ArrayOf<TypeMeta> typeMetas;
    private final ArrayOf<FieldKeyMeta> keyMetas;
    private final ArrayOf<FieldsKey> memoryKeys;

    RuntimeMetaData() {
        this.imports = new Imports();
        this.typeMetas = new ArrayOf<TypeMeta>(TypeMeta.class);
        this.memoryKeys = new ArrayOf<FieldsKey>(FieldsKey.class);
        this.properties = new ConcurrentHashMap<String, Object>();
        this.keyMetas = new ArrayOf<FieldKeyMeta>(FieldKeyMeta.class);
    }

    RuntimeMetaData(RuntimeMetaData<?> parent) {
        this.imports = parent.imports.copyOf();
        this.properties = new ConcurrentHashMap<String, Object>(parent.properties);
        this.memoryKeys = new ArrayOf<FieldsKey>(parent.memoryKeys);
        this.typeMetas = new ArrayOf<TypeMeta>(TypeMeta.class);
        parent.typeMetas.forEach((meta, i) -> this.typeMetas.set(i, meta.copyOf()));
        this.keyMetas = new ArrayOf<FieldKeyMeta>(FieldKeyMeta.class);
        parent.keyMetas.forEach((meta, i) -> this.keyMetas.set(i, meta.copyOf()));
    }

    protected abstract void onNewActiveField(TypeMemoryState var1, ActiveField var2);

    public abstract void onNewAlphaBucket(TypeMemoryState var1, FieldsKey var2, AlphaBucketMeta var3);

    void forEachAlphaCondition(Consumer<AlphaEvaluator> consumer) {
        this.typeMetas.forEach(meta -> {
            for (AlphaEvaluator evaluator : ((TypeMeta)meta).alphaEvaluators) {
                consumer.accept(evaluator);
            }
        });
    }

    private TypeMeta getTypeMeta(Type<?> type) {
        return this.typeMetas.computeIfAbsent(type.getId(), k -> new TypeMeta(type));
    }

    private FieldKeyMeta getKeyMeta(FieldsKey key) {
        return this.keyMetas.computeIfAbsent(key.getId(), k -> new FieldKeyMeta());
    }

    private ActiveField getCreate(TypeField field) {
        TypeMeta meta = this.getTypeMeta(field.getDeclaringType());
        return meta.getCreate(field, newField -> {
            TypeMemoryState newState = meta.asState();
            this.onNewActiveField(newState, newField);
        });
    }

    synchronized AlphaBucketMeta buildAlphaMask(FieldsKey key, Set<EvaluatorWrapper> alphaEvaluators) {
        TypeMeta typeMeta = this.getTypeMeta(key.getType());
        AlphaEvaluator[] existing = typeMeta.alphaEvaluators;
        HashSet<AlphaEvaluator.Match> matches = new HashSet<AlphaEvaluator.Match>();
        for (EvaluatorWrapper evaluatorWrapper : alphaEvaluators) {
            AlphaEvaluator.Match match = AlphaEvaluator.search(existing, evaluatorWrapper);
            if (match == null) {
                AlphaEvaluator alphaEvaluator = typeMeta.append(evaluatorWrapper, this.convertDescriptor(evaluatorWrapper.descriptor()));
                existing = typeMeta.alphaEvaluators;
                matches.add(new AlphaEvaluator.Match(alphaEvaluator, true));
                continue;
            }
            matches.add(match);
        }
        FieldKeyMeta fieldKeyMeta = this.getKeyMeta(key);
        for (AlphaBucketMeta meta : fieldKeyMeta.alphaBuckets) {
            if (!meta.sameKey(matches)) continue;
            return meta;
        }
        int n = fieldKeyMeta.alphaBuckets.length;
        AlphaBucketMeta newMeta = AlphaBucketMeta.factory(n, matches);
        FieldKeyMeta.access$302(fieldKeyMeta, Arrays.copyOf(fieldKeyMeta.alphaBuckets, fieldKeyMeta.alphaBuckets.length + 1));
        ((FieldKeyMeta)fieldKeyMeta).alphaBuckets[n] = newMeta;
        this.onNewAlphaBucket(typeMeta.asState(), key, newMeta);
        return newMeta;
    }

    private ActiveField[] convertDescriptor(FieldReference[] descriptor) {
        ActiveField[] converted = new ActiveField[descriptor.length];
        for (int i = 0; i < descriptor.length; ++i) {
            ActiveField activeField;
            TypeField field = descriptor[i].field();
            converted[i] = activeField = this.getCreate(field);
        }
        return converted;
    }

    private ActiveField[] getCreate(Set<TypeField> fields) {
        HashSet set = new HashSet(fields.size());
        fields.forEach(f -> set.add(this.getCreate((TypeField)f)));
        ActiveField[] activeFields = set.toArray(ActiveField.ZERO_ARRAY);
        Arrays.sort(activeFields, DEFAULT_FIELD_COMPARATOR);
        return activeFields;
    }

    FieldsKey getCreateMemoryKey(FactTypeBuilder builder) {
        Object[] activeFields;
        Set<TypeField> fields = builder.getBetaTypeFields();
        Type<?> type = builder.getType();
        if (fields.isEmpty()) {
            activeFields = ActiveField.ZERO_ARRAY;
        } else {
            activeFields = this.getCreate(fields);
            Set distinctTypes = Arrays.stream(activeFields).map(TypeField::getDeclaringType).collect(Collectors.toSet());
            assert (distinctTypes.size() == 1 && ((Type)distinctTypes.iterator().next()).equals(type));
        }
        for (int i = 0; i < ((FieldsKey[])this.memoryKeys.data).length; ++i) {
            FieldsKey key = this.memoryKeys.getChecked(i);
            if (!Arrays.equals(key.getFields(), activeFields) || !type.equals(key.getType())) continue;
            return key;
        }
        int newId = ((FieldsKey[])this.memoryKeys.data).length;
        FieldsKey newKey = new FieldsKey(newId, type, (ActiveField[])activeFields);
        this.memoryKeys.set(newId, newKey);
        return newKey;
    }

    ActiveField[] getActiveFields(Type<?> t) {
        return this.getTypeMeta(t).activeFields;
    }

    TypeMemoryState getActiveSate(Type<?> t) {
        return this.getTypeMeta(t).asState();
    }

    AlphaEvaluator[] getAlphaEvaluators(Type<?> t) {
        return this.getTypeMeta(t).alphaEvaluators;
    }

    @Override
    public RuntimeContext<?> addImport(RuleScope scope, String imp) {
        this.imports.add(scope, imp);
        return this;
    }

    @Override
    public final Set<String> getImports(RuleScope ... scopes) {
        return this.imports.get(scopes);
    }

    public Imports getImportsData() {
        return this.imports;
    }

    @Override
    public final C set(String property, Object value) {
        this.properties.put(property, value);
        return (C)this;
    }

    @Override
    public final <T> T get(String property) {
        return (T)this.properties.get(property);
    }

    @Override
    public final Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public abstract ExpressionResolver getExpressionResolver();

    private static class TypeMeta
    implements Copyable<TypeMeta> {
        private ActiveField[] activeFields;
        private AlphaEvaluator[] alphaEvaluators;
        private final Type<?> type;

        TypeMeta(Type<?> type) {
            this.activeFields = ActiveField.ZERO_ARRAY;
            this.alphaEvaluators = new AlphaEvaluator[0];
            this.type = type;
        }

        TypeMemoryState asState() {
            return new TypeMemoryState(this.type, this.activeFields, this.alphaEvaluators);
        }

        TypeMeta(TypeMeta other) {
            this.activeFields = Arrays.copyOf(other.activeFields, other.activeFields.length);
            this.alphaEvaluators = Arrays.copyOf(other.alphaEvaluators, other.alphaEvaluators.length);
            this.type = other.type;
        }

        private synchronized AlphaEvaluator append(EvaluatorWrapper wrapper, ActiveField[] descriptor) {
            int newId = this.alphaEvaluators.length;
            AlphaEvaluator alphaEvaluator = new AlphaEvaluator(newId, wrapper, descriptor);
            this.alphaEvaluators = Arrays.copyOf(this.alphaEvaluators, this.alphaEvaluators.length + 1);
            this.alphaEvaluators[newId] = alphaEvaluator;
            return alphaEvaluator;
        }

        @Override
        public TypeMeta copyOf() {
            return new TypeMeta(this);
        }

        private synchronized ActiveField getCreate(TypeField field, NewActiveFieldListener listener) {
            for (ActiveField af : this.activeFields) {
                if (!af.getName().equals(field.getName())) continue;
                return af;
            }
            int id = this.activeFields.length;
            ActiveFieldImpl af = new ActiveFieldImpl(field, id);
            this.activeFields = Arrays.copyOf(this.activeFields, id + 1);
            this.activeFields[id] = af;
            listener.onNew(af);
            return af;
        }
    }

    private static class FieldKeyMeta
    implements Copyable<FieldKeyMeta> {
        private AlphaBucketMeta[] alphaBuckets;

        FieldKeyMeta() {
            this.alphaBuckets = new AlphaBucketMeta[0];
        }

        FieldKeyMeta(FieldKeyMeta other) {
            this.alphaBuckets = Arrays.copyOf(other.alphaBuckets, other.alphaBuckets.length);
        }

        @Override
        public FieldKeyMeta copyOf() {
            return new FieldKeyMeta(this);
        }

        static /* synthetic */ AlphaBucketMeta[] access$302(FieldKeyMeta x0, AlphaBucketMeta[] x1) {
            x0.alphaBuckets = x1;
            return x1;
        }
    }

    @FunctionalInterface
    public static interface NewActiveFieldListener {
        public void onNew(ActiveField var1);
    }
}

