/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.evrete.api.EvaluationListener;
import org.evrete.api.EvaluationListeners;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.api.RhsContext;
import org.evrete.api.RuleScope;
import org.evrete.api.RuntimeRule;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.AbstractRuntimeRule;
import org.evrete.runtime.BetaEndNode;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.RhsFactType;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeLhs;

public class RuntimeRuleImpl
extends AbstractRuntimeRule
implements RuntimeRule,
EvaluationListeners {
    private static final boolean[] BOOLEANS = new boolean[]{true, false};
    private final AbstractRuleSession<?> runtime;
    private final RuleDescriptor descriptor;
    private final RuntimeLhs lhs;
    private final RhsGroupNode[] rhsGroupNodes;
    private final RhsFactType[] factTypeNodes;
    private final Map<String, Integer> nameMapping = new HashMap<String, Integer>();
    private final RhsContext rhsContext;
    private final BetaEndNode[] endNodes;
    private long rhsCallCounter = 0L;

    public RuntimeRuleImpl(RuleDescriptor rd, AbstractRuleSession<?> runtime) {
        super(runtime, rd, rd.getLhs().getFactTypes());
        this.descriptor = rd;
        this.runtime = runtime;
        this.lhs = new RuntimeLhs(this, rd.getLhs());
        RhsFactGroup[] rhsFactGroups = this.lhs.getFactGroups();
        this.rhsGroupNodes = new RhsGroupNode[rhsFactGroups.length];
        for (int i = 0; i < rhsFactGroups.length; ++i) {
            this.rhsGroupNodes[i] = new RhsGroupNode(rhsFactGroups[i]);
        }
        this.factTypeNodes = new RhsFactType[rd.factTypes.length];
        for (RhsFactGroup group : rhsFactGroups) {
            for (FactType factType : group.types()) {
                int idx = factType.getInRuleIndex();
                assert (this.factTypeNodes[idx] == null);
                this.factTypeNodes[idx] = new RhsFactType(runtime.getMemory(), factType, group);
                if (this.nameMapping.put(factType.getVar(), idx) == null) continue;
                throw new IllegalStateException();
            }
        }
        this.endNodes = this.lhs.getEndNodes().toArray(new BetaEndNode[0]);
        this.rhsContext = new RhsContextImpl();
    }

    void mergeNodeDeltas() {
        for (BetaEndNode endNode : this.lhs.getEndNodes()) {
            endNode.commitDelta();
        }
    }

    final long executeRhs() {
        this.rhsCallCounter = 0L;
        for (RhsFactType type : this.factTypeNodes) {
            type.resetState();
        }
        this.forEachFactGroup(0, false, this.rhs.andThen(ctx -> this.increaseCallCount()));
        return this.rhsCallCounter;
    }

    public BetaEndNode[] getEndNodes() {
        return this.endNodes;
    }

    private void forEachFactGroup(int group, boolean hasDelta, Consumer<RhsContext> consumer) {
        boolean last = group == this.rhsGroupNodes.length - 1;
        RhsGroupNode factGroup = this.rhsGroupNodes[group];
        for (boolean b : BOOLEANS) {
            boolean newHasDelta;
            factGroup.initIterator(b);
            boolean bl = newHasDelta = b || hasDelta;
            if (last) {
                if (!newHasDelta) continue;
                this.forEachKey(0, consumer);
                continue;
            }
            this.forEachFactGroup(group + 1, newHasDelta, consumer);
        }
    }

    private void forEachKey(int group, Consumer<RhsContext> consumer) {
        boolean last;
        RhsGroupNode factGroup = this.rhsGroupNodes[group];
        FactType[] types = factGroup.types;
        ReIterator<MemoryKey> iterator = factGroup.keyIterator;
        if (iterator.reset() == 0L) {
            return;
        }
        boolean bl = last = group == this.rhsGroupNodes.length - 1;
        while (iterator.hasNext()) {
            this.copyKeyState(iterator, types);
            if (last) {
                this.forEachFact(0, consumer);
                continue;
            }
            this.forEachKey(group + 1, consumer);
        }
    }

    private void forEachFact(int type, Consumer<RhsContext> consumer) {
        boolean last = type == this.factTypeNodes.length - 1;
        RhsFactType entry = this.factTypeNodes[type];
        ReIterator<FactHandleVersioned> it = entry.factIterator;
        if (it.reset() == 0L) {
            return;
        }
        while (it.hasNext()) {
            FactHandleVersioned handle = (FactHandleVersioned)it.next();
            if (entry.setCurrentFact(handle)) {
                if (last) {
                    consumer.accept(this.rhsContext);
                    continue;
                }
                this.forEachFact(type + 1, consumer);
                continue;
            }
            it.remove();
        }
    }

    private void increaseCallCount() {
        ++this.rhsCallCounter;
    }

    public void clear() {
        for (BetaEndNode endNode : this.lhs.getEndNodes()) {
            endNode.clear();
        }
    }

    @Override
    public RuntimeRule set(String property, Object value) {
        super.set(property, value);
        return this;
    }

    private void copyKeyState(ReIterator<MemoryKey> iterator, FactType[] types) {
        for (FactType type : types) {
            this.factTypeNodes[type.getInRuleIndex()].setCurrentKey((MemoryKey)iterator.next());
        }
    }

    public RuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public AbstractRuleSession<?> getRuntime() {
        return this.runtime;
    }

    @Override
    public RuntimeRule addImport(RuleScope scope, String imp) {
        super.addImport(scope, imp);
        return this;
    }

    @Override
    public void addListener(EvaluationListener listener) {
        for (BetaEndNode node : this.lhs.getEndNodes()) {
            node.forEachConditionNode(n -> n.getExpression().addListener(listener));
        }
    }

    @Override
    public void removeListener(EvaluationListener listener) {
        for (BetaEndNode node : this.lhs.getEndNodes()) {
            node.forEachConditionNode(n -> n.getExpression().removeListener(listener));
        }
    }

    RuntimeLhs getLhs() {
        return this.lhs;
    }

    public String toString() {
        return "RuntimeRule{name='" + this.getName() + "'}";
    }

    private static class RhsGroupNode {
        final RhsFactGroup group;
        final FactType[] types;
        ReIterator<MemoryKey> keyIterator;
        boolean currentDelta;

        RhsGroupNode(RhsFactGroup group) {
            this.group = group;
            this.types = group.types();
        }

        void initIterator(boolean delta) {
            this.currentDelta = delta;
            this.keyIterator = this.group.keyIterator(delta);
        }

        public String toString() {
            return "{source=" + this.group.toString() + ", delta=" + this.currentDelta + '}';
        }
    }

    private class RhsContextImpl
    implements RhsContext {
        private RhsContextImpl() {
        }

        @Override
        public RhsContext insert(Object obj) {
            RuntimeRuleImpl.this.runtime.insert(obj);
            return this;
        }

        @Override
        public final RhsContext update(Object obj) {
            Objects.requireNonNull(obj);
            for (RhsFactType state : RuntimeRuleImpl.this.factTypeNodes) {
                if (state.value != obj) continue;
                RuntimeRuleImpl.this.runtime.update(state.handle, state.value);
                return this;
            }
            throw new IllegalArgumentException("Fact " + obj + " not found in current RHS context");
        }

        @Override
        public final RhsContext delete(Object obj) {
            Objects.requireNonNull(obj);
            for (RhsFactType state : RuntimeRuleImpl.this.factTypeNodes) {
                if (state.value != obj) continue;
                RuntimeRuleImpl.this.runtime.delete(state.handle);
                return this;
            }
            throw new IllegalArgumentException("Fact " + obj + " not found in current RHS context");
        }

        @Override
        public RuntimeRule getRule() {
            return RuntimeRuleImpl.this;
        }

        @Override
        public Object getObject(String name) {
            Integer idx = (Integer)RuntimeRuleImpl.this.nameMapping.get(name);
            if (idx == null) {
                throw new IllegalArgumentException("Unknown type reference: " + name);
            }
            return ((RuntimeRuleImpl)RuntimeRuleImpl.this).factTypeNodes[idx.intValue()].value;
        }
    }
}

