/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Iterator;
import org.evrete.Configuration;
import org.evrete.api.KeyedFactStorage;
import org.evrete.api.MemoryFactory;
import org.evrete.api.Type;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.FactType;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.MemoryComponent;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.TypeMemoryState;
import org.evrete.runtime.evaluation.AlphaBucketMeta;

public class SessionMemory
extends MemoryComponent
implements Iterable<TypeMemory> {
    private final ArrayOf<TypeMemory> typedMemories = new ArrayOf<TypeMemory>(new TypeMemory[0]);

    SessionMemory(Configuration configuration, MemoryFactory memoryFactory) {
        super(memoryFactory, configuration);
    }

    @Override
    protected void clearLocalData() {
    }

    @Override
    public Iterator<TypeMemory> iterator() {
        return this.typedMemories.iterator();
    }

    void onNewActiveField(TypeMemoryState state) {
        this.getCreateUpdate(state);
    }

    void onNewAlphaBucket(TypeMemoryState newState, FieldsKey key, AlphaBucketMeta meta) {
        this.getCreateUpdate(newState).onNewAlphaBucket(key, meta);
    }

    KeyedFactStorage getBetaFactStorage(FactType factType) {
        Type<?> t = factType.getType();
        FieldsKey fields = factType.getFields();
        AlphaBucketMeta mask = factType.getAlphaMask();
        return this.get(t).get(fields).get(mask);
    }

    public TypeMemory get(Type<?> t) {
        return this.get(t.getId());
    }

    TypeMemory getCreateUpdate(TypeMemoryState state) {
        Type<?> t = state.type;
        TypeMemory m = this.typedMemories.get(t.getId());
        if (m == null) {
            m = new TypeMemory(this, state);
            this.typedMemories.set(t.getId(), m);
        } else {
            m.updateCachedData(state);
        }
        return m;
    }

    public TypeMemory get(int typeId) {
        TypeMemory m = this.typedMemories.get(typeId);
        if (m == null) {
            throw new IllegalStateException("Unknown type id: " + typeId);
        }
        return m;
    }

    @Override
    public void commitChanges() {
        for (MemoryComponent child : this.childComponents()) {
            child.commitChanges();
        }
    }
}

