/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.evrete.api.Action;
import org.evrete.api.FactHandle;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.FactStorage;
import org.evrete.api.ReIterator;
import org.evrete.api.Type;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.AtomicMemoryAction;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.KeyMemory;
import org.evrete.runtime.KeyMemoryBucket;
import org.evrete.runtime.MemoryActionBuffer;
import org.evrete.runtime.MemoryActionListener;
import org.evrete.runtime.MemoryComponent;
import org.evrete.runtime.RuntimeFact;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.TypeMemoryState;
import org.evrete.runtime.evaluation.AlphaBucketMeta;

public final class TypeMemory
extends MemoryComponent {
    private static final Logger LOGGER = Logger.getLogger(TypeMemory.class.getName());
    private final MemoryActionBuffer buffer;
    private final FactStorage<FactRecord> factStorage;
    private final Type<?> type;
    private final ArrayOf<KeyMemory> betaMemories = new ArrayOf<KeyMemory>(new KeyMemory[0]);
    private TypeMemoryState typeMemoryState;

    TypeMemory(SessionMemory sessionMemory, TypeMemoryState initialState) {
        super(sessionMemory);
        String identityMethod;
        this.type = initialState.type;
        this.buffer = new MemoryActionBuffer(this.configuration.getAsInteger("evrete.core.insert-buffer-size", 4096));
        switch (identityMethod = this.configuration.getProperty("evrete.core.fact-identity-strategy")) {
            case "equals": {
                this.factStorage = this.memoryFactory.newFactStorage(this.type, FactRecord.class, (o1, o2) -> Objects.equals(o1.instance, o2.instance));
                break;
            }
            case "identity": {
                this.factStorage = this.memoryFactory.newFactStorage(this.type, FactRecord.class, (o1, o2) -> o1.instance == o2.instance);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid identity method '" + identityMethod + "' in the configuration. Expected values are '" + "equals" + "' or '" + "identity" + "'");
            }
        }
        this.updateCachedData(initialState);
    }

    void updateCachedData(TypeMemoryState state) {
        this.typeMemoryState = state;
    }

    public Object getFact(FactHandle handle) {
        FactRecord record = this.getFactRecord(handle);
        return record == null ? null : record.instance;
    }

    private FactRecord getFactRecord(FactHandle handle) {
        FactRecord record = null;
        AtomicMemoryAction bufferedAction = this.buffer.get(handle);
        if (bufferedAction != null) {
            if (bufferedAction.action != Action.RETRACT) {
                record = bufferedAction.factRecord;
            }
        } else {
            record = this.getStoredRecord(handle);
        }
        return record;
    }

    FactRecord getStoredRecord(FactHandle handle) {
        return this.factStorage.getFact(handle);
    }

    public FactHandle add(Action action, FactHandle factHandle, FactRecord factRecord, MemoryActionListener listener) {
        this.buffer.add(action, factHandle, factRecord, listener);
        return factHandle;
    }

    FactHandle externalInsert(Object fact, MemoryActionListener actionListener) {
        FactRecord record = new FactRecord(fact);
        FactHandle handle = this.factStorage.insert(record);
        if (handle == null) {
            LOGGER.warning("Fact " + fact + " has been already inserted");
            return null;
        }
        return this.add(Action.INSERT, handle, record, actionListener);
    }

    public Type<?> getType() {
        return this.type;
    }

    @Override
    protected void clearLocalData() {
        this.factStorage.clear();
    }

    private void forEachMemoryComponent(Consumer<KeyMemoryBucket> consumer) {
        this.betaMemories.forEach(fm -> fm.forEachBucket(consumer));
    }

    @Override
    public void commitChanges() {
        for (MemoryComponent child : this.childComponents()) {
            child.commitChanges();
        }
    }

    void forEachFact(BiConsumer<FactHandle, Object> consumer) {
        this.factStorage.iterator().forEachRemaining(record -> {
            FactHandle handle = record.getHandle();
            Object fact = ((FactRecord)record.getInstance()).instance;
            AtomicMemoryAction bufferedAction = this.buffer.get(handle);
            if (bufferedAction == null) {
                consumer.accept(handle, fact);
            } else if (bufferedAction.action != Action.RETRACT) {
                consumer.accept(bufferedAction.handle, bufferedAction.factRecord.instance);
            }
        });
    }

    public void processBuffer() {
        Iterator<AtomicMemoryAction> it = this.buffer.actions();
        LinkedList<RuntimeFact> runtimeFacts = new LinkedList<RuntimeFact>();
        block5: while (it.hasNext()) {
            AtomicMemoryAction a = it.next();
            switch (a.action) {
                case RETRACT: {
                    this.factStorage.delete(a.handle);
                    continue block5;
                }
                case INSERT: {
                    runtimeFacts.add(new RuntimeFact(this.valueResolver, this.typeMemoryState, new FactHandleVersioned(a.handle), a.factRecord));
                    continue block5;
                }
                case UPDATE: {
                    FactRecord previous = this.factStorage.getFact(a.handle);
                    if (previous == null) {
                        LOGGER.warning("Unknown fact handle " + a.handle + ". Update operation skipped.");
                        continue block5;
                    }
                    FactRecord factRecord = a.factRecord;
                    FactHandle handle = a.handle;
                    int newVersion = previous.getVersion() + 1;
                    factRecord.updateVersion(newVersion);
                    this.factStorage.update(handle, factRecord);
                    FactHandleVersioned versioned = new FactHandleVersioned(handle, newVersion);
                    runtimeFacts.add(new RuntimeFact(this.valueResolver, this.typeMemoryState, versioned, factRecord));
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
        if (!runtimeFacts.isEmpty()) {
            this.forEachMemoryComponent(b -> b.insert(runtimeFacts));
        }
        this.buffer.clear();
    }

    public final KeyMemory get(FieldsKey fields) {
        KeyMemory fm = this.betaMemories.get(fields.getId());
        if (fm == null) {
            throw new IllegalArgumentException("No key memory exists for " + fields);
        }
        return fm;
    }

    KeyMemoryBucket touchMemory(FieldsKey key, AlphaBucketMeta alphaMeta) {
        return this.betaMemories.computeIfAbsent(key.getId(), i -> new KeyMemory(this, key)).getCreate(alphaMeta);
    }

    void onNewAlphaBucket(FieldsKey key, AlphaBucketMeta meta) {
        KeyMemoryBucket bucket = this.touchMemory(key, meta);
        ReIterator allFacts = this.factStorage.iterator();
        LinkedList<RuntimeFact> runtimeFacts = new LinkedList<RuntimeFact>();
        while (allFacts.hasNext()) {
            FactStorage.Entry rec = (FactStorage.Entry)allFacts.next();
            FactHandleVersioned fhv = new FactHandleVersioned(rec.getHandle(), ((FactRecord)rec.getInstance()).getVersion());
            runtimeFacts.add(new RuntimeFact(this.valueResolver, this.typeMemoryState, fhv, (FactRecord)rec.getInstance()));
        }
        bucket.insert(runtimeFacts);
        bucket.commitChanges();
    }
}

