/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.async;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CountedCompleter;
import org.evrete.runtime.BetaEndNode;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.async.Completer;
import org.evrete.runtime.async.NodeDeltaTask;

public class RuleHotDeploymentTask
extends Completer {
    private static final long serialVersionUID = 2586111817691770826L;
    private final transient RuntimeRuleImpl rule;

    public RuleHotDeploymentTask(RuntimeRuleImpl rule) {
        this.rule = rule;
    }

    @Override
    protected void execute() {
        LinkedList<NodeDeltaTask> deltaTasks = new LinkedList<NodeDeltaTask>();
        for (BetaEndNode endNode : this.rule.getEndNodes()) {
            NodeDeltaTask dt = new NodeDeltaTask(this, endNode, false);
            deltaTasks.add(dt);
        }
        Iterator it = deltaTasks.iterator();
        while (it.hasNext()) {
            NodeDeltaTask c = (NodeDeltaTask)it.next();
            this.addToPendingCount(1);
            if (it.hasNext()) {
                c.fork();
                continue;
            }
            c.compute();
        }
    }

    @Override
    public void onCompletion(CountedCompleter<?> caller) {
        for (BetaEndNode endNode : this.rule.getEndNodes()) {
            endNode.commitDelta();
        }
    }
}

