/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.evrete.api.Evaluator;
import org.evrete.api.FactBuilder;
import org.evrete.api.FieldReference;
import org.evrete.api.LhsBuilder;
import org.evrete.api.NamedType;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.TypeResolver;
import org.evrete.api.ValuesPredicate;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.builder.AbstractExpression;
import org.evrete.runtime.builder.FactTypeBuilder;
import org.evrete.runtime.builder.PredicateExpression0;
import org.evrete.runtime.builder.PredicateExpression1;
import org.evrete.runtime.builder.PredicateExpression2;
import org.evrete.runtime.builder.PredicateExpression3;
import org.evrete.runtime.builder.PredicateExpression4;
import org.evrete.runtime.builder.RuleBuilderImpl;
import org.evrete.runtime.evaluation.EvaluatorWrapper;
import org.evrete.util.MapOfSet;

public abstract class AbstractLhsBuilder<C extends RuntimeContext<C>, G extends AbstractLhsBuilder<C, ?>>
implements LhsBuilder<C> {
    private final RuleBuilderImpl<C> ruleBuilder;
    private final Map<String, FactTypeBuilder> declaredLhsTypes;
    private final Set<AbstractExpression> conditions = new HashSet<AbstractExpression>();
    private final Function<String, FactTypeBuilder> factTypeMapper;
    private Compiled compiledData;

    AbstractLhsBuilder(RuleBuilderImpl<C> ruleBuilder) {
        this.ruleBuilder = ruleBuilder;
        this.declaredLhsTypes = new HashMap<String, FactTypeBuilder>();
        this.factTypeMapper = this.declaredLhsTypes::get;
    }

    protected abstract G self();

    private TypeResolver getTypeResolver() {
        return this.ruleBuilder.getRuntimeContext().getTypeResolver();
    }

    public Compiled getCompiledData() {
        if (this.compiledData == null) {
            throw new IllegalStateException("Conditions not compiled");
        }
        return this.compiledData;
    }

    @Override
    public Function<String, NamedType> getFactTypeMapper() {
        return this.factTypeMapper::apply;
    }

    void compileConditions(AbstractRuntime<?, ?> runtime) {
        if (this.compiledData != null) {
            throw new IllegalStateException("Conditions already compiled");
        }
        this.compiledData = new Compiled(runtime, this);
    }

    private AbstractLhsBuilder<?, ?> locateLhsGroup(NamedType type) {
        FactTypeBuilder builder = this.factTypeMapper.apply(type.getVar());
        if (builder == null) {
            throw new IllegalStateException();
        }
        return builder.getGroup();
    }

    public Set<FactTypeBuilder> getDeclaredFactTypes() {
        return new HashSet<FactTypeBuilder>(this.declaredLhsTypes.values());
    }

    @Override
    public RuleBuilderImpl<C> getRuleBuilder() {
        return this.ruleBuilder;
    }

    public G where(String ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this.self();
        }
        for (String expression : expressions) {
            this.addExpression(expression);
        }
        return this.self();
    }

    public G where(String expression, double complexity) {
        this.addExpression(expression, complexity);
        return this.self();
    }

    public G where(Predicate<Object[]> predicate, double complexity, String ... references) {
        this.addExpression(predicate, complexity, references);
        return this.self();
    }

    public G where(Predicate<Object[]> predicate, String ... references) {
        this.addExpression(predicate, references);
        return this.self();
    }

    public G where(ValuesPredicate predicate, double complexity, String ... references) {
        this.addExpression(predicate, complexity, references);
        return this.self();
    }

    public G where(ValuesPredicate predicate, String ... references) {
        this.addExpression(predicate, references);
        return this.self();
    }

    public G where(Predicate<Object[]> predicate, double complexity, FieldReference ... references) {
        this.addExpression(predicate, complexity, references);
        return this.self();
    }

    public G where(Predicate<Object[]> predicate, FieldReference ... references) {
        this.addExpression(predicate, references);
        return this.self();
    }

    public G where(ValuesPredicate predicate, double complexity, FieldReference ... references) {
        this.addExpression(predicate, complexity, references);
        return this.self();
    }

    public G where(ValuesPredicate predicate, FieldReference ... references) {
        this.addExpression(predicate, references);
        return this.self();
    }

    private void addExpression(String expression, double complexity) {
        this.conditions.add(new PredicateExpression0(expression, complexity, this.ruleBuilder.getImportsData()));
    }

    private void addExpression(Predicate<Object[]> predicate, double complexity, String[] references) {
        this.conditions.add(new PredicateExpression2(predicate, complexity, references));
    }

    private void addExpression(Predicate<Object[]> predicate, String[] references) {
        this.conditions.add(new PredicateExpression2(predicate, references));
    }

    private void addExpression(ValuesPredicate predicate, double complexity, String[] references) {
        this.conditions.add(new PredicateExpression1(predicate, complexity, references));
    }

    private void addExpression(ValuesPredicate predicate, String[] references) {
        this.conditions.add(new PredicateExpression1(predicate, references));
    }

    private void addExpression(Predicate<Object[]> predicate, double complexity, FieldReference[] references) {
        this.conditions.add(new PredicateExpression3(predicate, complexity, references));
    }

    private void addExpression(Predicate<Object[]> predicate, FieldReference[] references) {
        this.conditions.add(new PredicateExpression3(predicate, references));
    }

    private void addExpression(ValuesPredicate predicate, double complexity, FieldReference[] references) {
        this.conditions.add(new PredicateExpression4(predicate, complexity, references));
    }

    private void addExpression(ValuesPredicate predicate, FieldReference[] references) {
        this.conditions.add(new PredicateExpression4(predicate, references));
    }

    private void addExpression(String expression) {
        this.conditions.add(new PredicateExpression0(expression, this.ruleBuilder.getImportsData()));
    }

    @Override
    public synchronized FactTypeBuilder addFactDeclaration(String name, Type<?> type) {
        this.checkRefName(name);
        FactTypeBuilder factType = new FactTypeBuilder(this, name, type);
        this.declaredLhsTypes.put(name, factType);
        return factType;
    }

    @Override
    public FactTypeBuilder addFactDeclaration(String name, String type) {
        return this.addFactDeclaration(name, this.getTypeResolver().getOrDeclare(type));
    }

    public G buildLhs(Collection<FactBuilder> facts) {
        if (facts == null || facts.isEmpty()) {
            return this.self();
        }
        for (FactBuilder f : facts) {
            Class<?> c = f.getResolvedType();
            if (c == null) {
                this.addFactDeclaration(f.getName(), f.getUnresolvedType());
                continue;
            }
            this.addFactDeclaration(f.getName(), (Class)c);
        }
        return this.self();
    }

    @Override
    public FactTypeBuilder addFactDeclaration(String name, Class<?> type) {
        Type<?> t = this.getTypeResolver().getOrDeclare(type);
        return this.addFactDeclaration(name, (Type)t);
    }

    private void checkRefName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Null or empty type reference in " + this.ruleBuilder);
        }
        if (this.declaredLhsTypes.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate type reference '" + name + "' in rule " + this.ruleBuilder);
        }
    }

    public static class Compiled {
        private static final Set<EvaluatorWrapper> EMPTY_ALPHA_CONDITIONS = new HashSet<EvaluatorWrapper>();
        private final Set<EvaluatorWrapper> betaConditions = new HashSet<EvaluatorWrapper>();
        private final MapOfSet<NamedType, EvaluatorWrapper> alphaConditions = new MapOfSet();
        private final AbstractLhsBuilder<?, ?> lhsBuilder;

        Compiled(AbstractRuntime<?, ?> runtime, AbstractLhsBuilder<?, ?> lhsBuilder) {
            this.lhsBuilder = lhsBuilder;
            for (AbstractExpression condition : ((AbstractLhsBuilder)lhsBuilder).conditions) {
                Evaluator evaluator = condition.build(runtime, lhsBuilder.getFactTypeMapper());
                this.addCondition(evaluator);
            }
        }

        private void addCondition(Evaluator e) {
            EvaluatorWrapper expression = new EvaluatorWrapper(e);
            FieldReference[] descriptor = expression.descriptor();
            Set<NamedType> involvedTypes = expression.getNamedTypes();
            if (involvedTypes.size() == 1) {
                NamedType type = involvedTypes.iterator().next();
                this.alphaConditions.add(type, expression);
            } else {
                HashSet<AbstractLhsBuilder> involvedGroups = new HashSet<AbstractLhsBuilder>();
                for (FieldReference ref : descriptor) {
                    FactTypeBuilder factTypeBuilder = (FactTypeBuilder)((AbstractLhsBuilder)this.lhsBuilder).factTypeMapper.apply(ref.type().getVar());
                    factTypeBuilder.addBetaField(ref);
                    AbstractLhsBuilder refBuilder = ((AbstractLhsBuilder)this.lhsBuilder).locateLhsGroup(ref.type());
                    involvedGroups.add(refBuilder);
                }
                if (!involvedGroups.contains(this.lhsBuilder)) {
                    throw new IllegalStateException("Aggregate group contains external condition: " + expression);
                }
                if (involvedGroups.size() == 1) {
                    this.betaConditions.add(expression);
                } else {
                    for (FieldReference ref : expression.descriptor()) {
                        AbstractLhsBuilder group = ((AbstractLhsBuilder)this.lhsBuilder).locateLhsGroup(ref.type());
                        if (group != this.lhsBuilder) continue;
                        throw new UnsupportedOperationException("Aggregate groups are currently not supported");
                    }
                }
            }
        }

        public Set<EvaluatorWrapper> getAlphaConditions(FactTypeBuilder builder) {
            return this.alphaConditions.getOrDefault(builder, (EvaluatorWrapper)((Object)EMPTY_ALPHA_CONDITIONS));
        }

        public Set<EvaluatorWrapper> getBetaConditions() {
            return this.betaConditions;
        }
    }
}

