/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.builder;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import org.evrete.api.Evaluator;
import org.evrete.api.FieldReference;
import org.evrete.api.IntToValue;
import org.evrete.api.NamedType;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.builder.AbstractExpression;

class PredicateExpression2
extends AbstractExpression {
    private final Predicate<Object[]> predicate;
    private final String[] references;

    PredicateExpression2(Predicate<Object[]> predicate, double complexity, String[] references) {
        super(complexity);
        if (complexity <= 0.0) {
            throw new IllegalArgumentException("Complexity must be positive");
        }
        this.predicate = predicate;
        this.references = references;
    }

    PredicateExpression2(Predicate<Object[]> predicate, String[] references) {
        this(predicate, 1.0, references);
    }

    @Override
    Evaluator build(AbstractRuntime<?, ?> runtime, Function<String, NamedType> typeMapper) {
        FieldReference[] descriptor = PredicateExpression2.resolveReferences(runtime, typeMapper, this.references);
        return new PredicateEvaluator(descriptor, this.predicate, this.getComplexity());
    }

    private static class PredicateEvaluator
    implements Evaluator {
        private final FieldReference[] descriptor;
        private final Predicate<Object[]> predicate;
        private final double complexity;
        private final Object[] sharedValues;

        PredicateEvaluator(FieldReference[] descriptor, Predicate<Object[]> predicate, double complexity) {
            this.descriptor = descriptor;
            this.predicate = predicate;
            this.complexity = complexity;
            this.sharedValues = new Object[descriptor.length];
        }

        @Override
        public FieldReference[] descriptor() {
            return this.descriptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean test(IntToValue values) {
            Object[] objectArray = this.sharedValues;
            synchronized (this.sharedValues) {
                for (int i = 0; i < this.sharedValues.length; ++i) {
                    this.sharedValues[i] = values.apply(i);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.predicate.test(this.sharedValues);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateEvaluator that = (PredicateEvaluator)o;
            return Arrays.equals(this.descriptor, that.descriptor) && this.predicate.equals(that.predicate);
        }

        public int hashCode() {
            return 31 * this.predicate.hashCode() + Arrays.hashCode(this.descriptor);
        }

        @Override
        public double getComplexity() {
            return this.complexity;
        }

        public String toString() {
            return this.predicate.toString();
        }
    }
}

