/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.evrete.api.ActiveField;
import org.evrete.api.ComplexityObject;
import org.evrete.runtime.FactType;
import org.evrete.runtime.evaluation.BetaEvaluator;
import org.evrete.runtime.evaluation.BetaEvaluatorSingle;
import org.evrete.runtime.evaluation.EvaluatorWrapper;
import org.evrete.util.Bits;

public class BetaEvaluatorGroup
implements BetaEvaluator {
    private final BetaEvaluatorSingle[] evaluators;
    private final Bits factTypeMask;
    private final Set<FactType> descriptor;
    private final double complexity;

    BetaEvaluatorGroup(Collection<BetaEvaluatorSingle> collection) {
        this.factTypeMask = new Bits();
        this.evaluators = collection.toArray(BetaEvaluatorSingle.ZERO_ARRAY);
        Arrays.sort(this.evaluators, Comparator.comparingDouble(ComplexityObject::getComplexity));
        HashSet<FactType> factTypes = new HashSet<FactType>();
        double comp = 0.0;
        for (BetaEvaluatorSingle ei : this.evaluators) {
            factTypes.addAll(ei.factTypes());
            this.factTypeMask.or(ei.getFactTypeMask());
            comp += ei.getComplexity();
        }
        this.complexity = comp;
        this.descriptor = Collections.unmodifiableSet(factTypes);
    }

    private BetaEvaluatorGroup(BetaEvaluatorGroup other) {
        this.factTypeMask = other.factTypeMask;
        this.complexity = other.complexity;
        this.descriptor = other.descriptor;
        this.evaluators = new BetaEvaluatorSingle[other.evaluators.length];
        for (int i = 0; i < this.evaluators.length; ++i) {
            this.evaluators[i] = other.evaluators[i].copyOf();
        }
    }

    @Override
    public boolean evaluatesField(ActiveField field) {
        for (BetaEvaluatorSingle e : this.evaluators) {
            if (!e.evaluatesField(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BetaEvaluatorGroup copyOf() {
        return new BetaEvaluatorGroup(this);
    }

    @Override
    public EvaluatorWrapper[] constituents() {
        return this.evaluators;
    }

    @Override
    public double getComplexity() {
        return this.complexity;
    }

    @Override
    public boolean test() {
        for (BetaEvaluatorSingle evaluator : this.evaluators) {
            if (evaluator.test()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<FactType> factTypes() {
        return this.descriptor;
    }

    @Override
    public Bits getFactTypeMask() {
        return this.factTypeMask;
    }

    public String toString() {
        return Arrays.toString(this.evaluators);
    }
}

