/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.evrete.api.Evaluator;
import org.evrete.api.FieldReference;
import org.evrete.api.NamedType;
import org.evrete.runtime.BetaFieldReference;
import org.evrete.runtime.FactType;
import org.evrete.runtime.evaluation.BetaEvaluator;
import org.evrete.runtime.evaluation.BetaEvaluatorGroup;
import org.evrete.runtime.evaluation.BetaEvaluatorSingle;
import org.evrete.runtime.evaluation.EvaluatorWrapper;
import org.evrete.util.MapOfSet;

public final class EvaluatorFactory {
    public static Collection<BetaEvaluator> flattenEvaluators(Collection<EvaluatorWrapper> rawEvaluators, Function<NamedType, FactType> typeFunction) {
        Collection<BetaEvaluatorSingle> evaluators = EvaluatorFactory.convert(rawEvaluators, typeFunction);
        MapOfSet<Set, Set> groupedConditions = new MapOfSet<Set, Set>();
        for (BetaEvaluatorSingle e : evaluators) {
            Set set = Arrays.stream(e.betaDescriptor()).map(BetaFieldReference::getFactType).collect(Collectors.toSet());
            groupedConditions.computeIfAbsent(set, k -> new HashSet()).add(e);
        }
        ArrayList<BetaEvaluator> result = new ArrayList<BetaEvaluator>(groupedConditions.size());
        for (Map.Entry entry : groupedConditions.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            if (collection.size() == 1) {
                result.add((BetaEvaluator)collection.iterator().next());
                continue;
            }
            result.add(EvaluatorFactory.flattenEvaluators(collection));
        }
        return result;
    }

    private static Collection<BetaEvaluatorSingle> convert(Collection<EvaluatorWrapper> rawEvaluators, Function<NamedType, FactType> typeFunction) {
        ArrayList<BetaEvaluatorSingle> evaluators = new ArrayList<BetaEvaluatorSingle>(rawEvaluators.size());
        for (EvaluatorWrapper e : rawEvaluators) {
            EvaluatorFactory.validateExpression(e);
            evaluators.add(new BetaEvaluatorSingle(e, typeFunction));
        }
        return evaluators;
    }

    private static BetaEvaluatorGroup flattenEvaluators(Collection<BetaEvaluatorSingle> collection) {
        assert (collection.size() > 0);
        return new BetaEvaluatorGroup(collection);
    }

    private static void validateExpression(Evaluator expression) {
        int refCount = expression.descriptor().length;
        HashSet<FieldReference> fields = new HashSet<FieldReference>(Arrays.asList(expression.descriptor()));
        if (fields.size() != refCount) {
            throw new UnsupportedOperationException("Duplicate field references like in 'a + a + b > 3' are currently not supported, please declare a new Type.Field instead.");
        }
    }
}

