/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.HashSet;
import java.util.Set;
import org.evrete.api.EvaluationListener;
import org.evrete.api.Evaluator;
import org.evrete.api.FieldReference;
import org.evrete.api.IntToValue;
import org.evrete.api.Listeners;
import org.evrete.api.NamedType;
import org.evrete.api.ValuesPredicate;

public class EvaluatorWrapper
implements Evaluator,
Listeners {
    private final Evaluator delegate;
    private final Set<EvaluationListener> listeners = new HashSet<EvaluationListener>();
    private final ValuesPredicate verboseUnmapped = new ValuesPredicate(){

        @Override
        public boolean test(IntToValue intToValue) {
            boolean b = EvaluatorWrapper.this.delegate.test(intToValue);
            for (EvaluationListener listener : EvaluatorWrapper.this.listeners) {
                listener.fire(EvaluatorWrapper.this.delegate, intToValue, b);
            }
            return b;
        }
    };
    private final Set<NamedType> namedTypes = new HashSet<NamedType>();
    private ValuesPredicate active;
    private IntToValue stateValues;

    public EvaluatorWrapper(Evaluator delegate) {
        this.delegate = EvaluatorWrapper.unwrap(delegate);
        for (FieldReference ref : delegate.descriptor()) {
            this.namedTypes.add(ref.type());
        }
        this.updateActiveEvaluator();
        this.stateValues = null;
    }

    EvaluatorWrapper(EvaluatorWrapper other) {
        this.delegate = EvaluatorWrapper.unwrap(other.delegate);
        this.listeners.addAll(other.listeners);
        this.namedTypes.addAll(other.namedTypes);
        this.updateActiveEvaluator();
        this.stateValues = null;
    }

    private static Evaluator unwrap(Evaluator e) {
        if (e instanceof EvaluatorWrapper) {
            EvaluatorWrapper wrapper = (EvaluatorWrapper)e;
            return EvaluatorWrapper.unwrap(wrapper.delegate);
        }
        return e;
    }

    Evaluator getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public final void addListener(EvaluationListener listener) {
        this.listeners.add(listener);
        this.updateActiveEvaluator();
    }

    @Override
    public final void removeListener(EvaluationListener listener) {
        this.listeners.remove(listener);
        this.updateActiveEvaluator();
    }

    public Set<NamedType> getNamedTypes() {
        return this.namedTypes;
    }

    private void updateActiveEvaluator() {
        this.active = this.listeners.isEmpty() ? this.delegate : this.verboseUnmapped;
    }

    @Override
    public final boolean test(IntToValue intToValue) {
        return this.active.test(intToValue);
    }

    public final void setStateValues(IntToValue stateValues) {
        this.stateValues = stateValues;
    }

    public final boolean test() {
        return this.test(this.stateValues);
    }

    @Override
    public final double getComplexity() {
        return this.delegate.getComplexity();
    }

    @Override
    public FieldReference[] descriptor() {
        return this.delegate.descriptor();
    }

    @Override
    public final int compare(Evaluator other) {
        return this.delegate.compare(EvaluatorWrapper.unwrap(other));
    }
}

