/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Collection;
import java.util.function.Function;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.IntToValueHandle;
import org.evrete.api.KeyMode;
import org.evrete.api.KeyedFactStorage;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueHandle;
import org.evrete.spi.minimal.AbstractFactsMap;
import org.evrete.util.CollectionUtils;

abstract class AbstractKeyedFactStorage<T extends AbstractFactsMap<?>>
implements KeyedFactStorage {
    private final T[] maps;
    KeyState currentRecord = null;

    AbstractKeyedFactStorage(Class<T> mapType, Function<KeyMode, T> mapSupplier) {
        this.maps = (AbstractFactsMap[])CollectionUtils.array(mapType, KeyMode.values().length);
        for (KeyMode mode : KeyMode.values()) {
            this.maps[mode.ordinal()] = (AbstractFactsMap)mapSupplier.apply(mode);
        }
    }

    abstract KeyState writeKey(ValueHandle var1);

    @Override
    public final ReIterator<FactHandleVersioned> values(KeyMode mode, MemoryKey key) {
        return ((AbstractFactsMap)this.get(mode)).values(key);
    }

    @Override
    public final void clear() {
        for (T map : this.maps) {
            ((AbstractFactsMap)map).clear();
        }
    }

    private void insert(IntToValueHandle key, int keyHash, Collection<FactHandleVersioned> factHandles) {
        if (((AbstractFactsMap)this.get(KeyMode.MAIN)).hasKey(keyHash, key)) {
            ((AbstractFactsMap)this.get(KeyMode.KNOWN_UNKNOWN)).add(key, keyHash, factHandles);
        } else {
            ((AbstractFactsMap)this.get(KeyMode.UNKNOWN_UNKNOWN)).add(key, keyHash, factHandles);
        }
    }

    @Override
    public void write(ValueHandle partialKey) {
        this.currentRecord = this.writeKey(partialKey);
    }

    @Override
    public void write(Collection<FactHandleVersioned> factHandles) {
        this.insert(this.currentRecord.values, this.currentRecord.hash, factHandles);
        this.currentRecord = null;
    }

    @Override
    public final ReIterator<MemoryKey> keys(KeyMode keyMode) {
        return ((AbstractFactsMap)this.get(keyMode)).keys();
    }

    final T get(KeyMode mode) {
        return this.maps[mode.ordinal()];
    }

    static class KeyState {
        int hash;
        IntToValueHandle values;

        KeyState() {
        }
    }
}

