/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.evrete.api.Evaluator;
import org.evrete.api.ExpressionResolver;
import org.evrete.api.FieldReference;
import org.evrete.api.NamedType;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.spi.minimal.ConditionStringTerm;
import org.evrete.spi.minimal.Const;
import org.evrete.spi.minimal.EvaluatorCompiler;
import org.evrete.spi.minimal.FieldReferenceImpl;
import org.evrete.spi.minimal.JcCompiler;
import org.evrete.util.BaseConditionClass;
import org.evrete.util.NextIntSupplier;
import org.evrete.util.StringLiteralRemover;
import org.evrete.util.compiler.CompilationException;

class DefaultExpressionResolver
implements ExpressionResolver {
    private static final String BASE_CLASS_PROPERTY = "org.evrete.minimal.condition-base-class";
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("\\$[a-zA-Z0-9]+(\\.[_a-zA-Z][_a-zA-Z0-9]*)*");
    private final EvaluatorCompiler evaluatorCompiler;
    private final String conditionBaseClassName;

    DefaultExpressionResolver(RuntimeContext<?> requester, JcCompiler compiler) {
        this.evaluatorCompiler = new EvaluatorCompiler(compiler);
        this.conditionBaseClassName = requester.getConfiguration().getProperty(BASE_CLASS_PROPERTY, BaseConditionClass.class.getName());
    }

    @Override
    public FieldReference resolve(String arg, Function<String, NamedType> resolver) {
        TypeField field;
        NamedType typeRef;
        int firstDot = arg.indexOf(46);
        if (firstDot < 0) {
            typeRef = resolver.apply(arg);
            if (typeRef == null) {
                throw new IllegalArgumentException("There's no declared reference '" + arg + "' in provided context.");
            }
            Type<?> type = typeRef.getType();
            field = type.getField("this");
            if (field == null) {
                throw new IllegalArgumentException("Type implementation doesn't support default 'this' field for " + type + ". As a workaround, use a specific type field in your expression rather than referencing the whole type.");
            }
        } else {
            String lhsFactType = arg.substring(0, firstDot);
            String dottedProp = arg.substring(firstDot + 1);
            Const.assertName(dottedProp);
            Const.assertName(lhsFactType.substring(1));
            typeRef = resolver.apply(lhsFactType);
            if (typeRef == null) {
                throw new IllegalArgumentException("There's no declared reference '" + lhsFactType + "' in provided context.");
            }
            Type<?> type = typeRef.getType();
            field = type.getField(dottedProp);
            if (field == null) {
                throw new IllegalArgumentException("Unable to resolve property '" + dottedProp + "' of the type " + type);
            }
        }
        return new FieldReferenceImpl(typeRef, field);
    }

    @Override
    public synchronized Evaluator buildExpression(String rawExpression, Function<String, NamedType> resolver, Set<String> imports) throws CompilationException {
        try {
            return this.buildExpression(rawExpression, resolver, imports, true);
        }
        catch (Throwable e) {
            return this.buildExpression(rawExpression, resolver, imports, false);
        }
    }

    private Evaluator buildExpression(String rawExpression, Function<String, NamedType> resolver, Set<String> imports, boolean stripWhiteSpaces) throws CompilationException {
        StringLiteralRemover remover = StringLiteralRemover.of(rawExpression, stripWhiteSpaces);
        String strippedExpression = remover.getConverted();
        Matcher m = REFERENCE_PATTERN.matcher(strippedExpression);
        ArrayList<ConditionStringTerm> terms = new ArrayList<ConditionStringTerm>();
        NextIntSupplier fieldCounter = new NextIntSupplier();
        while (m.find()) {
            int end;
            int start = m.start();
            int actualEnd = end = m.end();
            if (end < strippedExpression.length() && strippedExpression.charAt(end) == '(') {
                actualEnd = strippedExpression.substring(start, end).lastIndexOf(46) + start;
            }
            String s = strippedExpression.substring(start, actualEnd);
            FieldReference fieldReference = this.resolve(s, resolver);
            ConditionStringTerm t = new ConditionStringTerm(start, actualEnd, fieldReference, fieldCounter);
            terms.add(t);
        }
        try {
            Class<?> baseClass = this.evaluatorCompiler.getClassLoader().loadClass(this.conditionBaseClassName);
            return this.evaluatorCompiler.buildExpression(baseClass, remover, strippedExpression, terms, imports);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load class '" + this.conditionBaseClassName + "'");
        }
    }
}

