/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import org.evrete.api.ActiveField;
import org.evrete.api.KeyMode;
import org.evrete.api.ValueHandle;
import org.evrete.spi.minimal.AbstractKeyedFactStorage;
import org.evrete.spi.minimal.FactsMapMulti;

class KeyedFactStorageMulti
extends AbstractKeyedFactStorage<FactsMapMulti> {
    private final int keyCount;
    private final MultiState multiState;

    KeyedFactStorageMulti(int initialSize, ActiveField[] fields) {
        super(FactsMapMulti.class, mode -> new FactsMapMulti(fields, (KeyMode)((Object)mode), initialSize));
        this.keyCount = fields.length;
        this.multiState = new MultiState(fields.length);
    }

    @Override
    AbstractKeyedFactStorage.KeyState writeKey(ValueHandle h) {
        return this.multiState.update(h);
    }

    @Override
    public void commitChanges() {
        FactsMapMulti main = (FactsMapMulti)this.get(KeyMode.MAIN);
        main.merge(this.get(KeyMode.UNKNOWN_UNKNOWN));
        main.merge(this.get(KeyMode.KNOWN_UNKNOWN));
    }

    private static class MultiState
    extends AbstractKeyedFactStorage.KeyState {
        private final ValueHandle[] data;
        private int currentPosition = 0;

        MultiState(int size) {
            this.data = new ValueHandle[size];
            this.values = i -> this.data[i];
        }

        MultiState update(ValueHandle h) {
            if (this.currentPosition == this.data.length) {
                this.currentPosition = 0;
                this.hash = 0;
            }
            this.data[this.currentPosition++] = h;
            this.hash += 37 * h.hashCode();
            return this;
        }
    }
}

