/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Arrays;
import org.evrete.api.ActiveField;
import org.evrete.api.FieldToValueHandle;
import org.evrete.api.IntToValueHandle;
import org.evrete.api.MemoryKey;
import org.evrete.api.ValueHandle;

class MemoryKeyMulti
implements MemoryKey {
    private final ValueHandle[] data;
    private final int hash;
    private transient int transientValue;

    MemoryKeyMulti(ValueHandle[] data, int hash) {
        this.data = data;
        this.hash = hash;
    }

    MemoryKeyMulti(ActiveField[] fields, FieldToValueHandle key, int hash) {
        this.data = new ValueHandle[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            this.data[i] = (ValueHandle)key.apply(fields[i]);
        }
        this.hash = hash;
    }

    MemoryKeyMulti(ActiveField[] fields, IntToValueHandle key, int hash) {
        this.data = new ValueHandle[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            this.data[i] = (ValueHandle)key.apply(i);
        }
        this.hash = hash;
    }

    @Override
    public int getMetaValue() {
        return this.transientValue;
    }

    @Override
    public void setMetaValue(int i) {
        this.transientValue = i;
    }

    public String toString() {
        return Arrays.toString(this.data) + "/" + this.transientValue;
    }

    @Override
    public ValueHandle get(int i) {
        return this.data[i];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryKeyMulti other = (MemoryKeyMulti)o;
        return other.transientValue == this.transientValue && Arrays.equals(other.data, this.data);
    }

    public final int hashCode() {
        return this.hash;
    }
}

