/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util.compiler;

import java.util.Collections;
import java.util.StringJoiner;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.evrete.util.compiler.BytesClassLoader;
import org.evrete.util.compiler.CompilationException;
import org.evrete.util.compiler.FileManager;
import org.evrete.util.compiler.JavaSource;

public class SourceCompiler {
    private static final Logger LOGGER = Logger.getLogger(SourceCompiler.class.getName());
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class<?> compile(String source, BytesClassLoader classLoader) throws CompilationException {
        JavaCompiler javaCompiler = this.compiler;
        synchronized (javaCompiler) {
            byte[] classBytes;
            FileManager<?> fileManager = FileManager.instance(this.compiler, classLoader);
            try {
                classBytes = this.compileInner(fileManager, source, Collections.singletonList("-parameters"));
            }
            catch (Exception e) {
                classBytes = this.compileInner(fileManager, source, null);
            }
            return classLoader.buildClass(classBytes);
        }
    }

    private byte[] compileInner(FileManager<?> fileManager, String source, Iterable<String> options) throws CompilationException {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        boolean success = this.compiler.getTask(null, fileManager, diagnostics, options, null, JavaSource.task(source)).call();
        if (!success) {
            StringJoiner errors = new StringJoiner(", ");
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                errors.add(diagnostic.toString());
            }
            throw new CompilationException("Unknown compilation error: " + errors + ". Check with error logs for the source code in question.", source);
        }
        return fileManager.getBytes();
    }
}

