/*
 * Decompiled with CFR 0.152.
 */
package org.evrete;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.StringJoiner;
import org.evrete.Configuration;
import org.evrete.SourceSecurity;
import org.evrete.api.Knowledge;
import org.evrete.api.OrderedServiceProvider;
import org.evrete.api.StatefulSession;
import org.evrete.api.spi.DSLKnowledgeProvider;
import org.evrete.api.spi.ExpressionResolverProvider;
import org.evrete.api.spi.LiteralRhsCompiler;
import org.evrete.api.spi.MemoryFactoryProvider;
import org.evrete.api.spi.TypeResolverProvider;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.runtime.async.ForkJoinExecutor;

public class KnowledgeService {
    private final Configuration configuration;
    private final ForkJoinExecutor executor;
    private final MemoryFactoryProvider collectionsServiceProvider;
    private final ExpressionResolverProvider expressionResolverProvider;
    private final TypeResolverProvider typeResolverProvider;
    private final LiteralRhsCompiler literalRhsProvider;
    private ClassLoader classLoader;
    private final SourceSecurity security = new SourceSecurity();

    public KnowledgeService(Configuration conf) {
        this.configuration = conf;
        this.executor = new ForkJoinExecutor(conf.getAsInteger("evrete.core.parallelism", Runtime.getRuntime().availableProcessors()));
        this.collectionsServiceProvider = KnowledgeService.loadService(MemoryFactoryProvider.class);
        this.expressionResolverProvider = KnowledgeService.loadService(ExpressionResolverProvider.class);
        this.typeResolverProvider = KnowledgeService.loadService(TypeResolverProvider.class);
        this.literalRhsProvider = KnowledgeService.loadService(LiteralRhsCompiler.class);
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public KnowledgeService() {
        this(new Configuration());
    }

    private static <Z extends OrderedServiceProvider> Z loadService(Class<Z> clazz) {
        LinkedList providers = new LinkedList();
        Iterator<Z> sl = ServiceLoader.load(clazz).iterator();
        sl.forEachRemaining(providers::add);
        Collections.sort(providers);
        if (providers.isEmpty()) {
            throw new IllegalStateException("Implementation missing: " + clazz);
        }
        return (Z)((OrderedServiceProvider)providers.iterator().next());
    }

    public SourceSecurity getSecurity() {
        return this.security;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Knowledge newKnowledge() {
        return new KnowledgeRuntime(this);
    }

    private static DSLKnowledgeProvider getDslProvider(String dsl) {
        Objects.requireNonNull(dsl);
        ServiceLoader<DSLKnowledgeProvider> loader = ServiceLoader.load(DSLKnowledgeProvider.class);
        LinkedList<DSLKnowledgeProvider> found = new LinkedList<DSLKnowledgeProvider>();
        StringJoiner knownProviders = new StringJoiner(",", "[", "]");
        for (DSLKnowledgeProvider provider : loader) {
            String name = provider.getName();
            if (dsl.equals(name)) {
                found.add(provider);
            }
            knownProviders.add("'" + name + "' = " + provider.getClass());
        }
        if (found.isEmpty()) {
            throw new IllegalStateException("DSL provider '" + dsl + "' is not found. Make sure the corresponding implementation is available on the classpath. Available providers: " + knownProviders);
        }
        if (found.size() > 1) {
            throw new IllegalStateException("Multiple DSL providers found implementing the '" + dsl + "' language. Known providers: " + knownProviders);
        }
        return (DSLKnowledgeProvider)found.iterator().next();
    }

    private static URL classToURL(Class<?> cl) {
        String resource = cl.getName().replaceAll("\\.", "/") + ".class";
        return cl.getClassLoader().getResource(resource);
    }

    public Knowledge newKnowledge(String dsl, URL ... resources) throws IOException {
        return KnowledgeService.getDslProvider(dsl).create(this, resources);
    }

    public Knowledge newKnowledge(String dsl, Reader ... resources) throws IOException {
        return KnowledgeService.getDslProvider(dsl).create(this, resources);
    }

    public Knowledge newKnowledge(String dsl, InputStream ... resources) throws IOException {
        return KnowledgeService.getDslProvider(dsl).create(this, resources);
    }

    public Knowledge newKnowledge(String dsl, Class<?> ... resources) throws IOException {
        if (resources == null || resources.length == 0) {
            throw new IOException("Empty resources");
        }
        URL[] urls = new URL[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            urls[i] = KnowledgeService.classToURL(resources[i]);
        }
        return KnowledgeService.getDslProvider(dsl).create(this, urls);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public ForkJoinExecutor getExecutor() {
        return this.executor;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public MemoryFactoryProvider getMemoryFactoryProvider() {
        return this.collectionsServiceProvider;
    }

    public ExpressionResolverProvider getExpressionResolverProvider() {
        return this.expressionResolverProvider;
    }

    public LiteralRhsCompiler getLiteralRhsCompiler() {
        return this.literalRhsProvider;
    }

    public TypeResolverProvider getTypeResolverProvider() {
        return this.typeResolverProvider;
    }

    public Knowledge newKnowledge(String dsl, String ... resources) throws IOException {
        if (resources == null || resources.length == 0) {
            throw new IOException("Empty resources");
        }
        Reader[] urls = new Reader[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            urls[i] = new StringReader(resources[i]);
        }
        return KnowledgeService.getDslProvider(dsl).create(this, urls);
    }

    public StatefulSession newSession() {
        return this.newKnowledge().createSession();
    }
}

