/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.IntToValueHandle;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.collections.LinearHashSet;
import org.evrete.spi.minimal.LinkedFactHandles;

abstract class AbstractFactsMap<K extends MemoryKey> {
    private static final ReIterator<FactHandleVersioned> EMPTY = ReIterator.emptyIterator();
    private final LinearHashSet<MapKey<K>> data;
    private final BiPredicate<MapKey<K>, IntToValueHandle> search;
    private final BiPredicate<MapKey<K>, K> SEARCH_PREDICATE = (entry, memoryKey) -> ((MemoryKey)entry.key).equals(memoryKey);
    private final Function<MapKey<K>, MemoryKey> ENTRY_MAPPER = entry -> (MemoryKey)entry.key;

    AbstractFactsMap(int minCapacity) {
        this.search = this::sameData;
        this.data = new LinearHashSet(minCapacity);
    }

    abstract boolean sameData(MapKey<K> var1, IntToValueHandle var2);

    abstract K newKeyInstance(IntToValueHandle var1, int var2);

    final ReIterator<MemoryKey> keys() {
        return this.data.iterator(this.ENTRY_MAPPER);
    }

    public final void add(IntToValueHandle key, int keyHash, Collection<FactHandleVersioned> factHandles) {
        this.data.resize();
        int addr = this.data.findBinIndex((MapKey<IntToValueHandle>)((Object)key), keyHash, this.search);
        MapKey<K> entry = (MapKey<K>)this.data.get(addr);
        if (entry == null) {
            K k = this.newKeyInstance(key, keyHash);
            entry = new MapKey<K>(k);
            this.data.saveDirect(entry, addr);
        }
        for (FactHandleVersioned h : factHandles) {
            entry.facts.add(h);
        }
    }

    final boolean hasKey(int hash, IntToValueHandle key) {
        int addr = this.data.findBinIndex((MapKey<IntToValueHandle>)((Object)key), hash, this.search);
        return this.data.get(addr) != null;
    }

    private int addr(K key) {
        return this.data.findBinIndex((MapKey<K>)key, key.hashCode(), this.SEARCH_PREDICATE);
    }

    final ReIterator<FactHandleVersioned> values(MemoryKey k) {
        int addr = this.addr(k);
        MapKey entry = (MapKey)this.data.get(addr);
        return entry == null ? EMPTY : entry.facts.iterator();
    }

    final void merge(AbstractFactsMap<K> other) {
        other.data.forEachDataEntry(this::merge);
        other.data.clear();
    }

    private void merge(MapKey<K> otherEntry) {
        int addr = this.addr((MemoryKey)otherEntry.key);
        MapKey found = (MapKey)this.data.get(addr);
        if (found == null) {
            this.data.add(otherEntry);
        } else {
            found.facts.consume(otherEntry.facts);
        }
    }

    public final void clear() {
        this.data.clear();
    }

    public final String toString() {
        return this.data.toString();
    }

    static class MapKey<K> {
        final LinkedFactHandles facts = new LinkedFactHandles();
        final K key;

        MapKey(K key) {
            this.key = key;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapKey mapKey = (MapKey)o;
            return this.key.equals(mapKey.key);
        }

        public final int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key + "={" + this.facts + '}';
        }
    }
}

