/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.api;

public class FactBuilder {
    private final String name;
    private final String unresolvedType;
    private final Class<?> resolvedType;

    private FactBuilder(String name, String unresolvedType, Class<?> resolvedType) {
        this.name = name;
        this.unresolvedType = unresolvedType;
        this.resolvedType = resolvedType;
    }

    private FactBuilder(String name, Class<?> resolvedType) {
        this(name, null, resolvedType);
    }

    private FactBuilder(String name, String unresolvedType) {
        this(name, unresolvedType, null);
    }

    public static FactBuilder fact(String name, String type) {
        if (name == null || type == null) {
            throw new NullPointerException();
        }
        return new FactBuilder(name, type);
    }

    public static FactBuilder fact(String name, Class<?> type) {
        if (name == null || type == null) {
            throw new NullPointerException();
        }
        return new FactBuilder(name, type);
    }

    public String getName() {
        return this.name;
    }

    public String getUnresolvedType() {
        return this.unresolvedType;
    }

    public Class<?> getResolvedType() {
        return this.resolvedType;
    }
}

