/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.evrete.api.Action;
import org.evrete.api.FactHandle;
import org.evrete.api.Knowledge;
import org.evrete.api.MemoryFactory;
import org.evrete.api.Rule;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuleSession;
import org.evrete.api.RuntimeRule;
import org.evrete.api.Type;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.DeltaMemoryManager;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.FactType;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.RuntimeRules;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.async.RuleHotDeploymentTask;
import org.evrete.runtime.evaluation.MemoryAddress;

public abstract class AbstractRuleSession<S extends RuleSession<S>>
extends AbstractRuntime<RuntimeRule, S>
implements RuleSession<S> {
    private static final Logger LOGGER = Logger.getLogger(AbstractRuleSession.class.getName());
    private final RuntimeRules ruleStorage;
    final SessionMemory memory;
    final DeltaMemoryManager deltaMemoryManager = new DeltaMemoryManager();
    private final KnowledgeRuntime knowledge;
    private final boolean warnUnknownTypes;
    private boolean active = true;

    AbstractRuleSession(KnowledgeRuntime knowledge) {
        super(knowledge);
        this.ruleStorage = new RuntimeRules();
        MemoryFactory memoryFactory = this.getService().getMemoryFactoryProvider().instance(this);
        this.memory = new SessionMemory(this, memoryFactory);
        this.knowledge = knowledge;
        this.warnUnknownTypes = knowledge.getConfiguration().getAsBoolean("evrete.core.warn-unknown-types");
        for (RuleDescriptor descriptor : knowledge.getRules()) {
            this.deployRule(descriptor, false);
        }
    }

    private void reSortRules() {
        this.ruleStorage.sort(this.getRuleComparator());
    }

    @Override
    public RuntimeRule compileRule(RuleBuilder<?> builder) {
        RuleDescriptor rd = this.compileRuleBuilder(builder);
        return this.deployRule(rd, true);
    }

    @Override
    public List<RuntimeRule> getRules() {
        return Collections.unmodifiableList(this.ruleStorage.getList());
    }

    RuntimeRules getRuleStorage() {
        return this.ruleStorage;
    }

    @Override
    public void setRuleComparator(Comparator<Rule> ruleComparator) {
        super.setRuleComparator(ruleComparator);
        this.reSortRules();
    }

    private synchronized RuntimeRule deployRule(RuleDescriptor descriptor, boolean hotDeployment) {
        for (FactType factType : descriptor.getLhs().getFactTypes()) {
            TypeMemory tm = this.memory.getCreateUpdate(factType.type());
            tm.touchMemory(factType.getMemoryAddress());
        }
        RuntimeRuleImpl rule = this.ruleStorage.addRule(descriptor, this);
        if (hotDeployment) {
            this.getExecutor().invoke(new RuleHotDeploymentTask(rule));
        }
        this.reSortRules();
        return rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AbstractRuleSession abstractRuleSession = this;
        synchronized (abstractRuleSession) {
            this.invalidateSession();
            this.knowledge.close(this);
        }
    }

    private void invalidateSession() {
        this.active = false;
        this.memory.destroy();
    }

    public Knowledge getParentContext() {
        return this.knowledge;
    }

    private void _assertActive() {
        if (!this.active) {
            throw new IllegalStateException("Session has been closed");
        }
    }

    public final SessionMemory getMemory() {
        return this.memory;
    }

    @Override
    public final FactHandle insert(Object fact) {
        this._assertActive();
        return this.insert(this.getTypeResolver().resolve(fact), fact);
    }

    @Override
    public final FactHandle insert(String type, Object fact) {
        this._assertActive();
        return this.insert(this.getTypeResolver().getType(type), fact);
    }

    @Override
    public Object getFact(FactHandle handle) {
        return this.memory.get(handle.getTypeId()).getFact(handle);
    }

    private FactHandle insert(Type<?> type, Object fact) {
        if (fact == null) {
            throw new NullPointerException("Null facts are not supported");
        }
        if (type == null) {
            if (this.warnUnknownTypes) {
                LOGGER.warning("Can not resolve type for " + fact + ", insert operation skipped.");
            }
            return null;
        }
        return this.memory.get(type).externalInsert(fact);
    }

    @Override
    public final void update(FactHandle handle, Object newValue) {
        this._assertActive();
        if (handle == null) {
            throw new NullPointerException("Null handle provided during update");
        }
        this.memory.get(handle.getTypeId()).add(Action.UPDATE, handle, new FactRecord(newValue));
    }

    @Override
    public final void delete(FactHandle handle) {
        this._assertActive();
        this.memory.get(handle.getTypeId()).add(Action.RETRACT, handle, null);
    }

    @Override
    public final void forEachFact(BiConsumer<FactHandle, Object> consumer) {
        for (TypeMemory tm : this.memory) {
            tm.forEachFact(consumer);
        }
    }

    @Override
    public <T> void forEachFact(String type, Consumer<T> consumer) {
        Type t = this.getTypeResolver().getType(type);
        if (t == null) {
            throw new IllegalArgumentException("Type not found: '" + type + "'");
        }
        this.memory.getCreateUpdate(t.getId()).forEachFact((handle, o) -> consumer.accept(o));
    }

    @Override
    public void onNewActiveField(ActiveField newField) {
        this.memory.onNewActiveField(newField);
    }

    @Override
    public final void onNewAlphaBucket(MemoryAddress address) {
        this.memory.onNewAlphaBucket(address);
    }

    @Override
    public void clear() {
        for (RuntimeRuleImpl rule : this.ruleStorage) {
            rule.clear();
        }
        this.memory.clear();
    }

    @Override
    public <T> Future<T> fireAsync(T result) {
        return this.getExecutor().submit(this::fire, result);
    }
}

