/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.evrete.api.TypeField;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.Mask;

public class FactType {
    public static final FactType[] ZERO_ARRAY = new FactType[0];
    private static final Comparator<FactType> COMPARATOR = Comparator.comparingInt(FactType::getInRuleIndex);
    private final String name;
    private final MemoryAddress memoryAddress;
    private final int inRuleIndex;
    private final Mask<MemoryAddress> memoryMask;

    FactType(String name, MemoryAddress memoryAddress, int inRuleIndex) {
        this.name = name;
        this.memoryAddress = memoryAddress;
        this.inRuleIndex = inRuleIndex;
        this.memoryMask = Mask.addressMask();
        this.memoryMask.set(memoryAddress);
    }

    FactType(FactType other) {
        this.name = other.name;
        this.memoryAddress = other.memoryAddress;
        this.inRuleIndex = other.inRuleIndex;
        this.memoryMask = other.memoryMask;
    }

    public Mask<MemoryAddress> getMemoryMask() {
        return this.memoryMask;
    }

    public static FactType[] toArray(Collection<FactType> set) {
        FactType[] arr = set.toArray(ZERO_ARRAY);
        Arrays.sort(arr, COMPARATOR);
        return arr;
    }

    int findFieldPosition(TypeField field) {
        ActiveField[] arr = this.memoryAddress.fields().getFields();
        for (int i = 0; i < arr.length; ++i) {
            ActiveField f = arr[i];
            if (f.field() != field.getId()) continue;
            return i;
        }
        throw new IllegalStateException("Field not found");
    }

    public MemoryAddress getMemoryAddress() {
        return this.memoryAddress;
    }

    public String getName() {
        return this.name;
    }

    public int type() {
        return this.memoryAddress.fields().type();
    }

    public int getInRuleIndex() {
        return this.inRuleIndex;
    }

    public String toString() {
        return this.name;
    }
}

