/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import org.evrete.KnowledgeService;
import org.evrete.api.Knowledge;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuleSession;
import org.evrete.api.StatefulSession;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.StatefulSessionImpl;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.SearchList;

public class KnowledgeRuntime
extends AbstractRuntime<RuleDescriptor, Knowledge>
implements Knowledge {
    private final WeakHashMap<RuleSession<?>, Object> sessions = new WeakHashMap();
    private final Object VALUE = new Object();
    private final SearchList<RuleDescriptor> ruleDescriptors = new SearchList();

    public KnowledgeRuntime(KnowledgeService service) {
        super(service);
    }

    @Override
    public void onNewActiveField(ActiveField newField) {
    }

    @Override
    public void onNewAlphaBucket(MemoryAddress address) {
    }

    @Override
    public RuleDescriptor compileRule(RuleBuilder<?> builder) {
        RuleDescriptor rd = super.compileRuleBuilder(builder);
        this.ruleDescriptors.add(rd);
        this.ruleDescriptors.sort(this.getRuleComparator());
        return rd;
    }

    @Override
    public List<RuleDescriptor> getRules() {
        return Collections.unmodifiableList(this.ruleDescriptors.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(RuleSession<?> session) {
        WeakHashMap<RuleSession<?>, Object> weakHashMap = this.sessions;
        synchronized (weakHashMap) {
            this.sessions.remove(session);
        }
    }

    @Override
    public RuleDescriptor getRule(String name) {
        return this.ruleDescriptors.get(name);
    }

    @Override
    public Collection<RuleSession<?>> getSessions() {
        return Collections.unmodifiableCollection(this.sessions.keySet());
    }

    @Override
    public StatefulSession createSession() {
        StatefulSessionImpl session = new StatefulSessionImpl(this);
        this.sessions.put(session, this.VALUE);
        return session;
    }
}

