/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.ValueHandle;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.FactRecord;

public class RuntimeFact {
    static final RuntimeFact DUMMY_FACT = new RuntimeFact(){

        @Override
        final boolean sameValues(RuntimeFact other) {
            return false;
        }
    };
    private static final BitSet EMPTY = new BitSet();
    private final ValueHandle[] valueHandles;
    public final FactHandleVersioned factHandle;
    final BitSet alphaTests;
    public final FactRecord factRecord;

    private RuntimeFact() {
        this.factHandle = null;
        this.alphaTests = EMPTY;
        this.valueHandles = new ValueHandle[0];
        this.factRecord = null;
    }

    RuntimeFact(FactRecord factRecord, FactHandleVersioned factHandle, ValueHandle[] valueHandles, BitSet alphaTests) {
        this.valueHandles = valueHandles;
        this.factHandle = factHandle;
        this.alphaTests = alphaTests;
        this.factRecord = factRecord;
    }

    ValueHandle getValue(ActiveField field) {
        return this.valueHandles[field.getValueIndex()];
    }

    boolean sameValues(RuntimeFact other) {
        if (other == null) {
            return false;
        }
        for (int i = 0; i < this.valueHandles.length; ++i) {
            if (Objects.equals(this.valueHandles[i], other.valueHandles[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "{handle=" + this.factHandle + ", values=" + Arrays.toString(this.valueHandles) + '}';
    }
}

