/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.evrete.api.ActivationManager;
import org.evrete.api.RuntimeRule;
import org.evrete.api.StatefulSession;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.ActivationContext;
import org.evrete.runtime.BetaEndNode;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.async.Completer;
import org.evrete.runtime.async.ConditionMemoryPurgeTask;
import org.evrete.runtime.async.ForkJoinExecutor;
import org.evrete.runtime.async.MemoryDeltaTask;
import org.evrete.runtime.async.MemoryPurgeTask;
import org.evrete.runtime.async.RuleMemoryInsertTask;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.Mask;

public class StatefulSessionImpl
extends AbstractRuleSession<StatefulSession>
implements StatefulSession {
    private ActivationManager activationManager;
    private BooleanSupplier fireCriteria = () -> true;

    StatefulSessionImpl(KnowledgeRuntime knowledge) {
        super(knowledge);
        this.activationManager = this.newActivationManager();
    }

    private void applyFireCriteria(BooleanSupplier fireCriteria) {
        this.fireCriteria = fireCriteria;
    }

    @Override
    public StatefulSession setActivationManager(ActivationManager activationManager) {
        this.applyActivationManager(activationManager);
        return this;
    }

    @Override
    public StatefulSession setFireCriteria(BooleanSupplier fireCriteria) {
        this.applyFireCriteria(fireCriteria);
        return this;
    }

    @Override
    public RuntimeRule getRule(String name) {
        return (RuntimeRule)this.getRuleStorage().get(name);
    }

    @Override
    public ActivationManager getActivationManager() {
        return this.activationManager;
    }

    private void applyActivationManager(ActivationManager activationManager) {
        this.activationManager = activationManager;
    }

    @Override
    public void fire() {
        switch (this.getAgendaMode()) {
            case DEFAULT: {
                this.fireDefault(new ActivationContext());
                break;
            }
            case CONTINUOUS: {
                this.fireContinuous(new ActivationContext());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode " + (Object)((Object)this.getAgendaMode()));
            }
        }
        this.purge();
    }

    private void fireContinuous(ActivationContext ctx) {
        while (this.fireCriteria.getAsBoolean() && this.deltaMemoryManager.hasMemoryChanges()) {
            this.processBuffer();
            List<RuntimeRule> agenda = this.buildMemoryDeltas();
            if (!agenda.isEmpty()) {
                this.activationManager.onAgenda(ctx.incrementFireCount(), agenda);
                for (RuntimeRule candidate : agenda) {
                    RuntimeRuleImpl rule = (RuntimeRuleImpl)candidate;
                    if (!this.activationManager.test(candidate)) continue;
                    this.activationManager.onActivation(rule, rule.executeRhs());
                }
            }
            this.commitRuleDeltas();
            this.commitBuffer();
        }
    }

    private void fireDefault(ActivationContext ctx) {
        boolean bufferProcessed = false;
        while (this.fireCriteria.getAsBoolean() && this.deltaMemoryManager.hasMemoryChanges()) {
            List<RuntimeRule> agenda;
            if (!bufferProcessed) {
                this.processBuffer();
                bufferProcessed = true;
            }
            if (!(agenda = this.buildMemoryDeltas()).isEmpty()) {
                this.activationManager.onAgenda(ctx.incrementFireCount(), agenda);
                for (RuntimeRule candidate : agenda) {
                    RuntimeRuleImpl rule = (RuntimeRuleImpl)candidate;
                    if (!this.activationManager.test(candidate)) continue;
                    this.activationManager.onActivation(rule, rule.executeRhs());
                    int deltaOperations = this.deltaMemoryManager.deltaOperations();
                    if (deltaOperations > 0) {
                        bufferProcessed = false;
                        break;
                    }
                    this.processBuffer();
                    bufferProcessed = true;
                }
                this.commitRuleDeltas();
            }
            this.commitBuffer();
        }
    }

    private void processBuffer() {
        MemoryDeltaTask deltaTask = new MemoryDeltaTask(this.memory.iterator());
        this.getExecutor().invoke(deltaTask);
        this.deltaMemoryManager.onDelete(deltaTask.getDeleteMask());
        this.deltaMemoryManager.onInsert(deltaTask.getInsertMask());
        this.deltaMemoryManager.clearBufferData();
    }

    private void commitBuffer() {
        this.memory.commitBuffer();
    }

    private void commitRuleDeltas() {
        for (RuntimeRuleImpl rule : this.getRuleStorage()) {
            rule.commitDeltas();
        }
    }

    private List<RuntimeRule> buildMemoryDeltas() {
        LinkedList<RuntimeRule> affectedRules = new LinkedList<RuntimeRule>();
        HashSet<BetaEndNode> affectedEndNodes = new HashSet<BetaEndNode>();
        Mask<MemoryAddress> matchMask = this.deltaMemoryManager.getInsertDeltaMask();
        for (RuntimeRuleImpl rule : this.getRuleStorage()) {
            boolean ruleAdded = false;
            for (RhsFactGroup group : rule.getLhs().getFactGroups()) {
                if (!matchMask.intersects(group.getMemoryMask())) continue;
                if (!ruleAdded) {
                    affectedRules.add(rule);
                    ruleAdded = true;
                }
                if (!(group instanceof BetaEndNode)) continue;
                affectedEndNodes.add((BetaEndNode)group);
            }
        }
        LinkedList<RuleMemoryInsertTask> tasks = new LinkedList<RuleMemoryInsertTask>();
        if (!affectedEndNodes.isEmpty()) {
            tasks.add(new RuleMemoryInsertTask(affectedEndNodes, matchMask, true));
        }
        if (tasks.size() > 0) {
            ForkJoinExecutor executor = this.getExecutor();
            for (Completer completer : tasks) {
                executor.invoke(completer);
            }
        }
        this.deltaMemoryManager.clearDeltaData();
        return affectedRules;
    }

    private void purge() {
        Mask<MemoryAddress> factPurgeMask = this.deltaMemoryManager.getDeleteDeltaMask();
        if (factPurgeMask.cardinality() > 0) {
            ForkJoinExecutor executor = this.getExecutor();
            MemoryPurgeTask purgeTask = new MemoryPurgeTask(this.memory, factPurgeMask);
            executor.invoke(purgeTask);
            Mask<MemoryAddress> emptyKeysMask = purgeTask.getKeyPurgeMask();
            if (emptyKeysMask.cardinality() > 0) {
                executor.invoke(new ConditionMemoryPurgeTask(this.getRuleStorage(), emptyKeysMask));
            }
            this.deltaMemoryManager.clearDeleteData();
        }
    }
}

