/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.async;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.evrete.api.FactHandle;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.FactStorage;
import org.evrete.runtime.AtomicMemoryAction;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.KeyMemoryBucket;
import org.evrete.runtime.MemoryActionBuffer;
import org.evrete.runtime.RuntimeFact;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.async.Completer;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.Mask;

public class MemoryDeltaTask
extends Completer {
    private static final long serialVersionUID = 7911593735990639599L;
    private static final Logger LOGGER = Logger.getLogger(TypeMemory.class.getName());
    private final Collection<TypeMemoryDeltaTask> subtasks = new LinkedList<TypeMemoryDeltaTask>();
    private final transient Mask<MemoryAddress> deleteMask = Mask.addressMask();
    private final transient Mask<MemoryAddress> insertMask = Mask.addressMask();

    public MemoryDeltaTask(Iterator<TypeMemory> typeMemories) {
        typeMemories.forEachRemaining(t -> this.subtasks.add(new TypeMemoryDeltaTask(this, (TypeMemory)t)));
    }

    @Override
    protected void execute() {
        this.tailCall(this.subtasks, o -> o);
    }

    public Mask<MemoryAddress> getDeleteMask() {
        return this.deleteMask;
    }

    public Mask<MemoryAddress> getInsertMask() {
        return this.insertMask;
    }

    @Override
    protected void onCompletion() {
        Iterator<TypeMemoryDeltaTask> it = this.subtasks.iterator();
        while (it.hasNext()) {
            TypeMemoryDeltaTask sub = it.next();
            this.deleteMask.or(sub.deleteMask);
            this.insertMask.or(sub.insertMask);
            it.remove();
        }
    }

    static class TypeMemoryDeltaTask
    extends Completer {
        private static final long serialVersionUID = 7844452444442224060L;
        private final transient TypeMemory tm;
        private final transient MemoryActionBuffer buffer;
        private final transient FactStorage<FactRecord> factStorage;
        private final transient Mask<MemoryAddress> deleteMask = Mask.addressMask();
        private final transient Mask<MemoryAddress> insertMask = Mask.addressMask();
        private final Collection<RuntimeFact> inserts = new LinkedList<RuntimeFact>();
        private final Collection<BucketInsertTask> bucketInsertTasks = new LinkedList<BucketInsertTask>();

        TypeMemoryDeltaTask(Completer completer, TypeMemory tm) {
            super(completer);
            this.tm = tm;
            this.buffer = tm.getBuffer();
            this.factStorage = tm.getFactStorage();
        }

        @Override
        protected void onCompletion() {
            this.buffer.clear();
            for (BucketInsertTask task : this.bucketInsertTasks) {
                if (!task.atLeastOneInserted) continue;
                this.insertMask.set(((BucketInsertTask)task).bucket.address);
            }
            this.inserts.clear();
            this.bucketInsertTasks.clear();
        }

        @Override
        protected void execute() {
            Iterator<AtomicMemoryAction> it = this.buffer.actions();
            block5: while (it.hasNext()) {
                AtomicMemoryAction a = it.next();
                switch (a.action) {
                    case RETRACT: {
                        FactRecord record = this.factStorage.getFact(a.handle);
                        if (record != null) {
                            this.deleteMask.or(record.getBucketsMask());
                        }
                        this.factStorage.delete(a.handle);
                        continue block5;
                    }
                    case INSERT: {
                        this.inserts.add(this.tm.createFactRuntime(new FactHandleVersioned(a.handle), a.factRecord));
                        continue block5;
                    }
                    case UPDATE: {
                        FactRecord previous = this.factStorage.getFact(a.handle);
                        if (previous == null) {
                            LOGGER.warning("Unknown fact handle " + a.handle + ". Update operation skipped.");
                            continue block5;
                        }
                        FactRecord factRecord = a.factRecord;
                        this.deleteMask.or(previous.getBucketsMask());
                        FactHandle handle = a.handle;
                        int newVersion = previous.getVersion() + 1;
                        factRecord.updateVersion(newVersion);
                        this.factStorage.update(handle, factRecord);
                        FactHandleVersioned versioned = new FactHandleVersioned(handle, newVersion);
                        this.inserts.add(this.tm.createFactRuntime(versioned, factRecord));
                        continue block5;
                    }
                }
                throw new IllegalStateException();
            }
            if (!this.inserts.isEmpty()) {
                for (KeyMemoryBucket bucket : this.tm) {
                    this.addToPendingCount(1);
                    BucketInsertTask task = new BucketInsertTask(this, bucket, this.inserts);
                    this.bucketInsertTasks.add(task);
                    task.fork();
                }
                this.postInsert();
            }
        }

        private void postInsert() {
            for (RuntimeFact fact : this.inserts) {
                FactHandle handle;
                FactRecord record;
                Mask<MemoryAddress> mask = fact.factRecord.getBucketsMask();
                if (mask.cardinality() <= 0 || (record = this.factStorage.getFact(handle = fact.factHandle.getHandle())) == null) continue;
                if (record.getBucketsMask().equals(mask)) {
                    return;
                }
                this.factStorage.update(handle, fact.factRecord);
            }
        }
    }

    static class BucketInsertTask
    extends Completer {
        private static final long serialVersionUID = -1537128295059722535L;
        private final transient KeyMemoryBucket bucket;
        private final transient Iterable<RuntimeFact> inserts;
        private boolean atLeastOneInserted;

        BucketInsertTask(TypeMemoryDeltaTask completer, KeyMemoryBucket bucket, Iterable<RuntimeFact> inserts) {
            super(completer);
            this.bucket = bucket;
            this.inserts = inserts;
        }

        @Override
        protected void execute() {
            this.atLeastOneInserted = this.bucket.insert(this.inserts);
        }
    }
}

