/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import org.evrete.api.ReIterable;
import org.evrete.api.ReIterator;
import org.evrete.util.CollectionUtils;

public class ArrayOf<T>
implements ReIterable<T> {
    private static final int NULL_INDEX = -1;
    public T[] data;

    public ArrayOf(T[] data) {
        this.data = data;
    }

    public ArrayOf(ArrayOf<T> other) {
        this.data = Arrays.copyOf(other.data, other.data.length);
    }

    public ArrayOf(Class<T> type) {
        this(CollectionUtils.array(type, 0));
    }

    private int computeSize() {
        int size = 0;
        for (T o : this.data) {
            if (o == null) continue;
            ++size;
        }
        return size;
    }

    public void append(T element) {
        int ret = this.data.length;
        this.data = Arrays.copyOf(this.data, ret + 1);
        this.data[ret] = element;
    }

    public void set(int index, T element) {
        if (index >= this.data.length) {
            this.data = Arrays.copyOf(this.data, index + 1);
        }
        this.data[index] = element;
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        for (T obj : this.data) {
            if (obj == null) continue;
            consumer.accept(obj);
        }
    }

    @Override
    public void forEach(ObjIntConsumer<? super T> consumer) {
        for (int i = 0; i < this.data.length; ++i) {
            T obj = this.data[i];
            if (obj == null) continue;
            consumer.accept(obj, i);
        }
    }

    public T computeIfAbsent(int idx, IntFunction<T> supplier) {
        T obj = this.get(idx);
        if (obj == null) {
            obj = supplier.apply(idx);
            this.set(idx, obj);
        }
        return obj;
    }

    public T getChecked(int i) {
        T obj = this.get(i);
        if (obj == null) {
            throw new IllegalStateException("No data initialized for " + i);
        }
        return obj;
    }

    public T get(int i) {
        if (i >= this.data.length || i < 0) {
            return null;
        }
        return this.data[i];
    }

    public void clear() {
        Arrays.fill(this.data, null);
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    @Override
    public ReIterator<T> iterator() {
        return new It();
    }

    private class It
    implements ReIterator<T> {
        private int cursor;

        It() {
            this.init();
        }

        private void init() {
            this.cursor = this.findNonNullIndex(0);
        }

        private int findNonNullIndex(int startInclusive) {
            for (int current = startInclusive; current < ArrayOf.this.data.length; ++current) {
                if (ArrayOf.this.data[current] == null) continue;
                return current;
            }
            return -1;
        }

        @Override
        public long reset() {
            this.init();
            return ArrayOf.this.computeSize();
        }

        @Override
        public boolean hasNext() {
            return this.cursor != -1;
        }

        @Override
        public T next() {
            Object obj = ArrayOf.this.data[this.cursor];
            this.cursor = this.findNonNullIndex(this.cursor + 1);
            return obj;
        }
    }
}

