/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringJoiner;
import org.evrete.api.ReIterable;
import org.evrete.api.ReIterator;

public class LinkedDataRWD<T>
implements ReIterable<T> {
    private long size;
    private Node<T> firstNode;
    private Node<T> lastNode;

    public LinkedDataRWD<T> add(T object) {
        Node<T> node;
        if (this.lastNode == null) {
            node = new Node<T>(object, null);
            this.firstNode = node;
        } else {
            node = new Node<T>(object, this.lastNode);
            this.lastNode.next = node;
            node.prev = this.lastNode;
        }
        this.lastNode = node;
        this.updateSize(1L);
        return this;
    }

    private void updateSize(long delta) {
        this.size += delta;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(",", "[", "]");
        this.iterator().forEachRemaining(t -> sj.add(t == null ? "null" : t.toString()));
        return sj.toString();
    }

    public void consume(LinkedDataRWD<T> other) {
        if (other.size > 0L) {
            Iterator iterator = other.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                this.add(t);
                iterator.remove();
            }
        }
    }

    public long size() {
        return this.size;
    }

    Node<T> first() {
        return this.firstNode;
    }

    Node<T> last() {
        return this.lastNode;
    }

    private void setFirst(Node<T> node) {
        this.firstNode = node;
        if (node == null) {
            this.lastNode = null;
            this.size = 0L;
        } else {
            this.firstNode.prev = null;
        }
    }

    private void setLast(Node<T> node) {
        this.lastNode = node;
        if (node == null) {
            this.firstNode = null;
            this.size = 0L;
        } else {
            this.lastNode.next = null;
        }
    }

    public void clear() {
        this.firstNode = null;
        this.lastNode = null;
        this.size = 0L;
    }

    private void removeNode(Node<T> last) {
        this.updateSize(-1L);
        if (last.prev == null) {
            this.setFirst(last.next);
            last.clearRefs();
        } else if (last.next == null) {
            this.setLast(last.prev);
            last.clearRefs();
        } else {
            last.drop();
        }
    }

    @Override
    public ReIterator<T> iterator() {
        return new It();
    }

    static class Node<Z> {
        Node<Z> prev;
        Node<Z> next;
        final Z data;

        Node(Z data, Node<Z> prev) {
            this.data = data;
            this.prev = prev;
        }

        void drop() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
            this.clearRefs();
        }

        void clearRefs() {
            this.next = null;
            this.prev = null;
        }
    }

    private class It
    implements ReIterator<T> {
        Node<T> next;
        Node<T> last;

        It() {
            this.next = LinkedDataRWD.this.firstNode;
        }

        @Override
        public long reset() {
            this.next = LinkedDataRWD.this.firstNode;
            this.last = null;
            return LinkedDataRWD.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = this.last.next;
            return this.last.data;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("Iterator: remove() without next()");
            }
            LinkedDataRWD.this.removeNode(this.last);
        }
    }
}

