/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryFactory;
import org.evrete.api.MemoryKey;
import org.evrete.api.MemoryKeyCollection;
import org.evrete.api.ReIterator;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.BetaConditionNode;
import org.evrete.runtime.BetaMemoryNode;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.MemoryKeyIterator;
import org.evrete.runtime.RuntimeRuleImpl;

public abstract class AbstractBetaConditionNode
implements BetaMemoryNode {
    private final ConditionNodeDescriptor descriptor;
    private final BetaMemoryNode[] sources;
    private final BetaConditionNode[] conditionSources;
    private final RuntimeRuleImpl rule;
    private final MemoryKeyCollection[] stores = new MemoryKeyCollection[KeyMode.values().length];
    private final MemoryKeyCollection tempCollection;
    private boolean mergeToMain = true;

    AbstractBetaConditionNode(RuntimeRuleImpl rule, ConditionNodeDescriptor descriptor, BetaMemoryNode[] sources) {
        this.sources = sources;
        ArrayList<BetaConditionNode> conditionNodeList = new ArrayList<BetaConditionNode>(sources.length);
        for (BetaMemoryNode source : sources) {
            if (!source.getDescriptor().isConditionNode()) continue;
            conditionNodeList.add((BetaConditionNode)source);
        }
        MemoryFactory memoryFactory = ((AbstractRuleSession)rule.getRuntime()).memory.memoryFactory;
        this.conditionSources = conditionNodeList.toArray(BetaConditionNode.EMPTY_ARRAY);
        this.rule = rule;
        this.descriptor = descriptor;
        for (KeyMode keyMode : KeyMode.values()) {
            MemoryKeyCollection store = memoryFactory.newMemoryKeyCollection(descriptor.getTypes());
            this.stores[keyMode.ordinal()] = keyMode == KeyMode.OLD_OLD ? new MemoryKeyCollectionWrapper(store, keyMode) : store;
        }
        this.tempCollection = memoryFactory.newMemoryKeyCollection(descriptor.getTypes());
    }

    public boolean hasMainStorage() {
        return this.mergeToMain;
    }

    void commitDelta1() {
        MemoryKeyCollection delta1 = this.getStore(KeyMode.NEW_NEW);
        MemoryKeyCollection delta2 = this.getStore(KeyMode.OLD_NEW);
        if (this.mergeToMain) {
            MemoryKeyCollection main = this.getStore(KeyMode.OLD_OLD);
            for (MemoryKey key : delta1) {
                main.add(key);
            }
        }
        delta1.clear();
        delta2.clear();
    }

    void setMergeToMain(boolean mergeToMain) {
        this.mergeToMain = mergeToMain;
    }

    public MemoryKeyCollection getStore(KeyMode mode) {
        return this.stores[mode.ordinal()];
    }

    public MemoryKeyCollection getTempCollection() {
        return this.tempCollection;
    }

    AbstractRuleSession<?> getRuntime() {
        return this.rule.getRuntime();
    }

    public BetaConditionNode[] getConditionSources() {
        return this.conditionSources;
    }

    BetaMemoryNode[] getSources() {
        return this.sources;
    }

    @Override
    public ConditionNodeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public ReIterator<MemoryKey> iterator(KeyMode mode) {
        return this.getStore(mode).iterator();
    }

    @Override
    public void clear() {
        for (MemoryKeyCollection s : this.stores) {
            s.clear();
        }
        for (BetaMemoryNode source : this.getSources()) {
            source.clear();
        }
    }

    private static class MemoryKeyCollectionWrapper
    implements MemoryKeyCollection {
        final MemoryKeyCollection delegate;
        final KeyMode forcedMode;

        MemoryKeyCollectionWrapper(MemoryKeyCollection delegate, KeyMode forcedMode) {
            this.delegate = delegate;
            this.forcedMode = forcedMode;
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public void add(MemoryKey key) {
            this.delegate.add(key);
        }

        @Override
        public ReIterator<MemoryKey> iterator() {
            return new MemoryKeyIterator((ReIterator<MemoryKey>)this.delegate.iterator(), this.forcedMode);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

