/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.async;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.MemoryKeyCollection;
import org.evrete.runtime.BetaConditionNode;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.async.Completer;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.Mask;

public class ConditionMemoryPurgeTask
extends Completer {
    private static final long serialVersionUID = 7911593735991639599L;
    private final Collection<SubTask> subtasks = new LinkedList<SubTask>();

    public ConditionMemoryPurgeTask(Iterable<RuntimeRuleImpl> rules, Mask<MemoryAddress> keyPurgeMask) {
        for (RuntimeRuleImpl rule : rules) {
            for (BetaConditionNode betaConditionNode : rule.getLhs().getEndNodes()) {
                BetaConditionNode.forEachConditionNode(betaConditionNode, cn -> {
                    if (cn.hasMainStorage() && cn.getDescriptor().getMemoryMask().intersects(keyPurgeMask)) {
                        this.subtasks.add(new SubTask(this, (BetaConditionNode)cn, keyPurgeMask));
                    }
                });
            }
        }
    }

    @Override
    protected void execute() {
        this.tailCall(this.subtasks, o -> o);
    }

    static class SubTask
    extends Completer {
        private static final long serialVersionUID = 8912306547512886112L;
        private final transient BetaConditionNode node;
        private final boolean[] checkFlags;
        private final MemoryKey[] buffer;

        SubTask(Completer completer, BetaConditionNode node, Mask<MemoryAddress> keyPurgeMask) {
            super(completer);
            this.node = node;
            FactType[] types = node.getDescriptor().getTypes();
            this.checkFlags = new boolean[types.length];
            for (int i = 0; i < types.length; ++i) {
                this.checkFlags[i] = types[i].getMemoryMask().intersects(keyPurgeMask);
            }
            this.buffer = new MemoryKey[types.length];
        }

        @Override
        protected void execute() {
            MemoryKeyCollection main = this.node.getStore(KeyMode.OLD_OLD);
            MemoryKeyCollection tempStore = this.node.getTempCollection();
            Iterator it = main.iterator();
            if (it.reset() == 0L) {
                return;
            }
            int i = 0;
            tempStore.clear();
            while (it.hasNext()) {
                MemoryKey key = (MemoryKey)it.next();
                this.buffer[i++] = key;
                if (i != this.buffer.length) continue;
                i = 0;
                if (!this.test()) continue;
                for (MemoryKey k : this.buffer) {
                    tempStore.add(k);
                }
            }
            main.clear();
            tempStore.forEach(main::add);
        }

        private boolean test() {
            for (int i = 0; i < this.buffer.length; ++i) {
                MemoryKey key;
                if (!this.checkFlags[i] || (key = this.buffer[i]).getMetaValue() != -1) continue;
                return false;
            }
            return true;
        }
    }
}

