/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.evrete.api.ComplexityObject;
import org.evrete.api.EvaluatorHandle;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.FactType;
import org.evrete.runtime.evaluation.BetaEvaluator;
import org.evrete.runtime.evaluation.BetaEvaluatorSingle;
import org.evrete.util.Mask;

public class BetaEvaluatorGroup
implements BetaEvaluator {
    private final EvaluatorHandle[] constituents;
    private final BetaEvaluatorSingle[] evaluators;
    private final Mask<FactType> factTypeMask = Mask.factTypeMask();
    private final Set<FactType> descriptor;
    private final double complexity;

    BetaEvaluatorGroup(Collection<BetaEvaluatorSingle> collection) {
        this.evaluators = collection.toArray(BetaEvaluatorSingle.ZERO_ARRAY);
        Arrays.sort(this.evaluators, Comparator.comparingDouble(ComplexityObject::getComplexity));
        HashSet<FactType> factTypes = new HashSet<FactType>();
        double comp = 0.0;
        this.constituents = new EvaluatorHandle[this.evaluators.length];
        for (int i = 0; i < this.evaluators.length; ++i) {
            BetaEvaluatorSingle ei = this.evaluators[i];
            factTypes.addAll(ei.factTypes());
            this.factTypeMask.or(ei.getFactTypeMask());
            this.constituents[i] = ei.constituents()[0];
            comp += ei.getComplexity();
        }
        this.complexity = comp;
        this.descriptor = Collections.unmodifiableSet(factTypes);
    }

    @Override
    public boolean evaluatesField(ActiveField field) {
        for (BetaEvaluatorSingle e : this.evaluators) {
            if (!e.evaluatesField(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EvaluatorHandle[] constituents() {
        return this.constituents;
    }

    @Override
    public double getComplexity() {
        return this.complexity;
    }

    @Override
    public Set<FactType> factTypes() {
        return this.descriptor;
    }

    @Override
    public Mask<FactType> getFactTypeMask() {
        return this.factTypeMask;
    }

    public String toString() {
        return Arrays.toString(this.evaluators);
    }
}

