/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.FieldReference;
import org.evrete.api.NamedType;
import org.evrete.api.TypeField;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.BetaFieldReference;
import org.evrete.runtime.FactType;
import org.evrete.runtime.evaluation.BetaEvaluator;
import org.evrete.util.Mask;

public class BetaEvaluatorSingle
implements BetaEvaluator {
    public static final BetaEvaluatorSingle[] ZERO_ARRAY = new BetaEvaluatorSingle[0];
    private final BetaFieldReference[] descriptor;
    private final Mask<FactType> factTypeMask;
    private final Set<FactType> factTypes;
    private final Set<ActiveField> fields;
    private final EvaluatorHandle[] constituents;
    private final EvaluatorHandle delegate;

    BetaEvaluatorSingle(EvaluatorHandle delegate, Function<NamedType, FactType> typeFunction) {
        this.delegate = delegate;
        this.factTypeMask = Mask.factTypeMask();
        this.fields = new HashSet<ActiveField>();
        this.constituents = new EvaluatorHandle[]{delegate};
        FieldReference[] evaluatorDescriptor = delegate.descriptor();
        this.descriptor = new BetaFieldReference[evaluatorDescriptor.length];
        HashSet<FactType> factTypes = new HashSet<FactType>();
        for (int i = 0; i < this.descriptor.length; ++i) {
            BetaFieldReference bfr;
            FieldReference fieldReference = evaluatorDescriptor[i];
            FactType factType = typeFunction.apply(fieldReference.type());
            TypeField field = fieldReference.field();
            this.descriptor[i] = bfr = new BetaFieldReference(factType, field);
            this.factTypeMask.set(factType);
            this.fields.add(bfr.getActiveField());
            factTypes.add(factType);
        }
        this.factTypes = Collections.unmodifiableSet(factTypes);
    }

    @Override
    public EvaluatorHandle[] constituents() {
        return this.constituents;
    }

    @Override
    public double getComplexity() {
        return this.delegate.getComplexity();
    }

    @Override
    public boolean evaluatesField(ActiveField field) {
        return this.fields.contains(field);
    }

    @Override
    public Set<FactType> factTypes() {
        return this.factTypes;
    }

    BetaFieldReference[] betaDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Mask<FactType> getFactTypeMask() {
        return this.factTypeMask;
    }
}

