/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.evrete.api.Copyable;
import org.evrete.api.RhsContext;
import org.evrete.api.StatefulSession;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeRuleImpl;

public class RhsAssert
implements Consumer<RhsContext>,
Copyable<RhsAssert> {
    private static final Function<RuleDescriptor, Entry[]> FROM_DESCRIPTOR = rule -> {
        FactType[] types = rule.getFactTypes();
        Entry[] entries = new Entry[types.length];
        int i = 0;
        for (FactType t : types) {
            entries[i++] = new Entry(t.getName());
        }
        return entries;
    };
    private static final Function<RuntimeRuleImpl, Entry[]> FROM_RULE = rule -> FROM_DESCRIPTOR.apply(rule.getDescriptor());
    private final Map<String, Collection<Object>> collector = new HashMap<String, Collection<Object>>();
    private final AtomicInteger callCounter = new AtomicInteger(0);
    private final Entry[] entries;
    private PrintStream out;

    private RhsAssert(Entry[] entries) {
        this.entries = entries;
        for (Entry entry : entries) {
            if (this.collector.put(entry.name, new HashSet()) == null) continue;
            throw new IllegalStateException("Duplicate entry name: " + entry.name);
        }
    }

    private RhsAssert(Supplier<Entry[]> supplier) {
        this(supplier.get());
    }

    private RhsAssert(RuntimeRuleImpl rule) {
        this(() -> FROM_RULE.apply(rule));
        rule.chainRhs(this);
    }

    public RhsAssert(StatefulSession statefulSession, String name) {
        this((RuntimeRuleImpl)statefulSession.getRule(name));
    }

    public RhsAssert(StatefulSession statefulSession) {
        this(RhsAssert.getSingleRule(statefulSession));
    }

    public RhsAssert(String var, Class<?> type) {
        this(new Entry[]{new Entry(var)});
    }

    public RhsAssert(String var1, Class<?> type1, String var2, Class<?> type2) {
        this(new Entry[]{new Entry(var1), new Entry(var2)});
    }

    public RhsAssert(String var1, Class<?> type1, String var2, Class<?> type2, String var3, Class<?> type3) {
        this(new Entry[]{new Entry(var1), new Entry(var2), new Entry(var3)});
    }

    public RhsAssert(String var1, Class<?> type1, String var2, Class<?> type2, String var3, Class<?> type3, String var4, Class<?> type4) {
        this(new Entry[]{new Entry(var1), new Entry(var2), new Entry(var3), new Entry(var4)});
    }

    public RhsAssert(String var1, Class<?> type1, String var2, Class<?> type2, String var3, Class<?> type3, String var4, Class<?> type4, String var5, Class<?> type5) {
        this(new Entry[]{new Entry(var1), new Entry(var2), new Entry(var3), new Entry(var4), new Entry(var5)});
    }

    public RhsAssert(String var1, Class<?> type1, String var2, Class<?> type2, String var3, Class<?> type3, String var4, Class<?> type4, String var5, Class<?> type5, String var6, Class<?> type6) {
        this(new Entry[]{new Entry(var1), new Entry(var2), new Entry(var3), new Entry(var4), new Entry(var5), new Entry(var6)});
    }

    private static RuntimeRuleImpl getSingleRule(StatefulSession s) {
        List rules = s.getRules();
        if (rules.size() == 0) {
            throw new IllegalStateException("Zero rule count, one expected");
        }
        if (rules.size() > 1) {
            throw new IllegalStateException("Multiple rule count, one expected");
        }
        return (RuntimeRuleImpl)rules.get(0);
    }

    @Override
    public RhsAssert copyOf() {
        return new RhsAssert(Arrays.copyOf(this.entries, this.entries.length));
    }

    public void reset() {
        this.callCounter.set(0);
        this.out = null;
        for (Collection<Object> objects : this.collector.values()) {
            objects.clear();
        }
    }

    @Override
    public void accept(RhsContext ctx) {
        this.callCounter.incrementAndGet();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, Collection<Object>> entry : this.collector.entrySet()) {
            String var2 = entry.getKey();
            Object o2 = ctx.get(var2);
            values.put(var2, o2);
            entry.getValue().add(o2);
        }
        if (this.out != null) {
            StringJoiner joiner = new StringJoiner(" ", ">>> ", "\t");
            values.forEach((var, o) -> joiner.add(var + "=" + o));
            this.out.println(joiner);
        }
    }

    public RhsAssert assertCount(int total) {
        assert (this.callCounter.get() == total) : "Actual " + this.callCounter.get() + " vs expected " + total;
        return this;
    }

    public int getCount() {
        return this.callCounter.get();
    }

    public void debugOut(PrintStream stream) {
        this.out = stream;
    }

    public void debugCounts(PrintStream stream) {
        HashMap map = new HashMap();
        this.collector.forEach((s, objects) -> map.put(s, objects.size()));
        stream.println(map);
    }

    public RhsAssert assertUniqueCount(String var, int count) {
        Collection<Object> list = this.collector.get(var);
        if (list == null) {
            throw new IllegalStateException("Unknown var '" + var + "'");
        }
        assert (list.size() == count) : "Actual size for '" + var + "' is " + list.size() + ", expected value: " + count;
        return this;
    }

    public RhsAssert assertContains(String var, Object o) {
        Collection<Object> list = this.collector.get(var);
        if (list == null) {
            throw new IllegalStateException("Unknown var '" + var + "'");
        }
        assert (list.contains(o));
        return this;
    }

    public RhsAssert assertNotContains(String var, Object o) {
        Collection<Object> list = this.collector.get(var);
        if (list == null) {
            throw new IllegalStateException("Unknown var '" + var + "'");
        }
        assert (!list.contains(o));
        return this;
    }

    private static class Entry {
        private final String name;

        Entry(String name) {
            this.name = name;
        }
    }
}

