/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.evrete.util.compiler.ClassBytesFileObject;
import org.evrete.util.compiler.JavaFileObjectImpl;
import org.evrete.util.compiler.PackageExplorer;

class FileManager<M extends JavaFileManager>
extends ForwardingJavaFileManager<M> {
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private final ClassLoader classLoader;
    private final PackageExplorer finder;

    private FileManager(M fileManager, ClassLoader classLoader) {
        super(fileManager);
        this.classLoader = classLoader;
        this.finder = new PackageExplorer(classLoader);
    }

    public static FileManager<?> instance(JavaCompiler compiler, ClassLoader classLoader) {
        return new FileManager<StandardJavaFileManager>(compiler.getStandardFileManager(null, null, null), classLoader);
    }

    byte[] getBytes() {
        try {
            this.bos.close();
            return this.bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavaFileObject o = super.getJavaFileForOutput(location, className, kind, sibling);
        return new ClassBytesFileObject<JavaFileObject>(o, this.bos);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return super.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        boolean knowledgeFiles;
        if (location.isOutputLocation()) {
            throw new IllegalStateException();
        }
        boolean bl = knowledgeFiles = (location == StandardLocation.SOURCE_PATH || location == StandardLocation.CLASS_PATH) && !packageName.startsWith("java");
        if (knowledgeFiles) {
            return this.finder.find(packageName);
        }
        return super.list(location, packageName, kinds, recurse);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof JavaFileObjectImpl) {
            return ((JavaFileObjectImpl)file).binaryName();
        }
        return super.inferBinaryName(location, file);
    }
}

