/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.api;

import java.util.Collection;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.evrete.api.FactHandle;
import org.evrete.api.RuleSession;

public interface StatefulSession
extends RuleSession<StatefulSession>,
AutoCloseable {
    public StatefulSession fire();

    public StatefulSession update(FactHandle var1, Object var2);

    public StatefulSession delete(FactHandle var1);

    public <T> T getFact(FactHandle var1);

    public <T> Future<T> fireAsync(T var1);

    default public Future<StatefulSession> fireAsync() {
        return this.fireAsync(this);
    }

    @Override
    public void close();

    public void clear();

    public StatefulSession forEachFact(BiConsumer<FactHandle, Object> var1);

    default public <T> StatefulSession forEachFact(Class<T> type, Consumer<T> consumer) {
        return this.forEachFact(type.getName(), consumer);
    }

    public <T> StatefulSession forEachFact(String var1, Consumer<T> var2);

    default public <T> StatefulSession forEachFact(Class<T> type, Predicate<T> filter, Consumer<T> consumer) {
        return this.forEachFact(type, (T t) -> {
            if (filter.test(t)) {
                consumer.accept(t);
            }
        });
    }

    default public <T> StatefulSession forEachFact(String type, Predicate<T> filter, Consumer<T> consumer) {
        return this.forEachFact(type, (T o) -> {
            Object t = o;
            if (filter.test(t)) {
                consumer.accept(t);
            }
        });
    }

    default public StatefulSession insertAndFire(Collection<?> objects) {
        this.insert(objects);
        return this.fire();
    }

    default public StatefulSession insertAndFire(Object ... objects) {
        this.insert(objects);
        return this.fire();
    }
}

