/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.evrete.runtime.EntryNodeDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.NodeDescriptor;
import org.evrete.runtime.evaluation.BetaEvaluator;

public final class ConditionNodeDescriptor
extends NodeDescriptor {
    public static final ConditionNodeDescriptor[] ZERO_ARRAY = new ConditionNodeDescriptor[0];
    private final BetaEvaluator expression;

    private ConditionNodeDescriptor(BetaEvaluator expression, Set<NodeDescriptor> sourceNodes) {
        super(sourceNodes);
        this.expression = expression;
    }

    static Collection<ConditionNodeDescriptor> allocateConditions(Collection<FactType> betaTypes, List<BetaEvaluator> list) {
        BetaEvaluator[] evaluatorSequence;
        HashSet<NodeDescriptor> unallocatedNodes = new HashSet<NodeDescriptor>();
        for (FactType factType : betaTypes) {
            EntryNodeDescriptor e = new EntryNodeDescriptor(factType);
            unallocatedNodes.add(e);
        }
        for (BetaEvaluator evaluator : evaluatorSequence = list.toArray(new BetaEvaluator[0])) {
            Set<NodeDescriptor> matching = unallocatedNodes.stream().filter(node -> node.getFactTypeMask().intersects(evaluator.getFactTypeMask())).collect(Collectors.toSet());
            assert (!matching.isEmpty());
            unallocatedNodes.removeAll(matching);
            unallocatedNodes.add(new ConditionNodeDescriptor(evaluator, matching));
        }
        ArrayList<ConditionNodeDescriptor> arrayList = new ArrayList<ConditionNodeDescriptor>(unallocatedNodes.size());
        for (NodeDescriptor nd : unallocatedNodes) {
            if (!nd.isConditionNode()) continue;
            ConditionNodeDescriptor cnd = (ConditionNodeDescriptor)nd;
            arrayList.add(cnd);
        }
        return arrayList;
    }

    @Override
    public boolean isConditionNode() {
        return true;
    }

    BetaEvaluator getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.expression.toString();
    }
}

