/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.api.KeyedFactStorage;
import org.evrete.api.MemoryFactory;
import org.evrete.api.ReIterator;
import org.evrete.api.Type;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.KeyMemoryBucket;
import org.evrete.runtime.MemoryComponent;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.TypeMemoryBase;
import org.evrete.runtime.evaluation.MemoryAddress;

public class SessionMemory
extends MemoryComponent
implements Iterable<TypeMemory> {
    private final ArrayOf<TypeMemory> typedMemories = new ArrayOf<TypeMemory>(new TypeMemory[0]);

    SessionMemory(AbstractRuleSession<?> runtime, MemoryFactory memoryFactory) {
        super(runtime, memoryFactory);
    }

    @Override
    protected void clearLocalData() {
    }

    @Override
    public ReIterator<TypeMemory> iterator() {
        return this.typedMemories.iterator();
    }

    void destroy() {
        this.clear();
        for (TypeMemory tm : this.typedMemories) {
            tm.destroy();
        }
    }

    void onNewActiveField(ActiveField newField) {
        this.getCreateUpdate(newField.type());
    }

    void onNewAlphaBucket(MemoryAddress address) {
        this.getCreateUpdate(address.fields().type()).onNewAlphaBucket(address);
    }

    KeyedFactStorage getBetaFactStorage(MemoryAddress address) {
        return this.getMemoryBucket(address).getFieldData();
    }

    KeyMemoryBucket getMemoryBucket(MemoryAddress address) {
        return this.get(address.fields().type()).getMemoryBucket(address);
    }

    public TypeMemory get(Type<?> t) {
        return this.get(t.getId());
    }

    TypeMemory getCreateUpdate(int type) {
        TypeMemory m = this.typedMemories.get(type);
        if (m == null) {
            m = new TypeMemory(this, type);
            this.typedMemories.set(type, m);
        } else {
            m.updateCachedData();
        }
        return m;
    }

    public TypeMemory get(int typeId) {
        TypeMemory m = this.typedMemories.get(typeId);
        if (m == null) {
            throw new IllegalStateException("Unknown type id: " + typeId);
        }
        return m;
    }

    void commitBuffer() {
        this.typedMemories.forEach(TypeMemoryBase::commitBuffer);
    }
}

