/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.evrete.api.ActivationManager;
import org.evrete.api.FactHandle;
import org.evrete.api.StatelessSession;
import org.evrete.api.Type;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.KnowledgeRuntime;

class StatelessSessionImpl
extends AbstractRuleSession<StatelessSession>
implements StatelessSession {
    StatelessSessionImpl(KnowledgeRuntime knowledge) {
        super(knowledge);
    }

    @Override
    public StatelessSession setActivationManager(ActivationManager activationManager) {
        this.applyActivationManager(activationManager);
        return this;
    }

    @Override
    public void fire(BiConsumer<FactHandle, Object> consumer) {
        try {
            this.fireInner();
            this.getMemory().forEach(tm -> tm.forEachFact(consumer));
        }
        finally {
            this.closeInner();
        }
    }

    @Override
    public void fire() {
        try {
            this.fireInner();
        }
        finally {
            this.closeInner();
        }
    }

    @Override
    public void fire(Consumer<Object> consumer) {
        try {
            this.fireInner();
            this.getMemory().forEach(tm -> tm.forEachFact((handle, o) -> consumer.accept(o)));
        }
        finally {
            this.closeInner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void fire(String type, Consumer<T> consumer) {
        try {
            this.fireInner();
            Type t = this.getTypeResolver().getType(type);
            if (t == null) {
                throw new IllegalArgumentException("No known type named '" + type + "'");
            }
            this.getMemory().get(t).forEachFact((factHandle, o) -> consumer.accept(o));
        }
        finally {
            this.closeInner();
        }
    }

    @Override
    public <T> void fire(Class<T> type, Consumer<T> consumer) {
        try {
            this.fireInner();
            this.getMemory().forEach(tm -> {
                if (type.equals(tm.type.getJavaType())) {
                    tm.forEachFact((factHandle, o) -> consumer.accept(o));
                }
            });
        }
        finally {
            this.closeInner();
        }
    }
}

