/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collector;
import org.evrete.api.Action;
import org.evrete.api.ActivationManager;
import org.evrete.api.FactHandle;
import org.evrete.api.Knowledge;
import org.evrete.api.MemoryFactory;
import org.evrete.api.Rule;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuleSession;
import org.evrete.api.RuntimeRule;
import org.evrete.api.SessionLifecycleListener;
import org.evrete.api.Type;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.ActivationContext;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.BetaEndNode;
import org.evrete.runtime.DeltaMemoryManager;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.FactType;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.RuntimeRules;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.async.Completer;
import org.evrete.runtime.async.ConditionMemoryPurgeTask;
import org.evrete.runtime.async.ForkJoinExecutor;
import org.evrete.runtime.async.MemoryDeltaTask;
import org.evrete.runtime.async.MemoryPurgeTask;
import org.evrete.runtime.async.RuleHotDeploymentTask;
import org.evrete.runtime.async.RuleMemoryInsertTask;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.Mask;
import org.evrete.util.SessionCollector;

public abstract class AbstractRuleSession<S extends RuleSession<S>>
extends AbstractRuntime<RuntimeRule, S>
implements RuleSession<S> {
    private static final Logger LOGGER = Logger.getLogger(AbstractRuleSession.class.getName());
    private final RuntimeRules ruleStorage;
    final SessionMemory memory;
    final DeltaMemoryManager deltaMemoryManager;
    private final KnowledgeRuntime knowledge;
    private final boolean warnUnknownTypes;
    private boolean active = true;
    private ActivationManager activationManager;
    private BooleanSupplier fireCriteria = () -> true;
    private final List<SessionLifecycleListener> lifecycleListeners = new ArrayList<SessionLifecycleListener>();

    AbstractRuleSession(KnowledgeRuntime knowledge) {
        super(knowledge);
        this.deltaMemoryManager = new DeltaMemoryManager();
        this.ruleStorage = new RuntimeRules();
        MemoryFactory memoryFactory = this.getService().getMemoryFactoryProvider().instance(this);
        this.memory = new SessionMemory(this, memoryFactory);
        this.knowledge = knowledge;
        this.warnUnknownTypes = knowledge.getConfiguration().getAsBoolean("evrete.core.warn-unknown-types");
        this.activationManager = this.newActivationManager();
        for (RuleDescriptor descriptor : knowledge.getRules()) {
            this.deployRule(descriptor, false);
        }
    }

    protected abstract S thisInstance();

    @Override
    public <T> Collector<T, ?, S> asCollector() {
        return new SessionCollector(this.thisInstance());
    }

    @Override
    public S setActivationManager(ActivationManager activationManager) {
        this.activationManager = activationManager;
        return this.thisInstance();
    }

    void fireInner() {
        for (SessionLifecycleListener e : this.lifecycleListeners) {
            e.onEvent(SessionLifecycleListener.Event.PRE_FIRE);
        }
        switch (this.getAgendaMode()) {
            case DEFAULT: {
                this.fireDefault(new ActivationContext());
                break;
            }
            case CONTINUOUS: {
                this.fireContinuous(new ActivationContext());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode " + (Object)((Object)this.getAgendaMode()));
            }
        }
        this.purge();
    }

    private void fireContinuous(ActivationContext ctx) {
        while (this.fireCriteriaMet() && this.deltaMemoryManager.hasMemoryChanges()) {
            this.processBuffer();
            List<RuntimeRule> agenda = this.buildMemoryDeltas();
            if (!agenda.isEmpty()) {
                this.activationManager.onAgenda(ctx.incrementFireCount(), agenda);
                for (RuntimeRule candidate : agenda) {
                    RuntimeRuleImpl rule = (RuntimeRuleImpl)candidate;
                    if (!this.activationManager.test(candidate)) continue;
                    this.activationManager.onActivation(rule, rule.executeRhs());
                }
            }
            this.commitRuleDeltas();
            this.commitBuffer();
        }
    }

    private void fireDefault(ActivationContext ctx) {
        boolean bufferProcessed = false;
        while (this.fireCriteriaMet() && this.deltaMemoryManager.hasMemoryChanges()) {
            List<RuntimeRule> agenda;
            if (!bufferProcessed) {
                this.processBuffer();
                bufferProcessed = true;
            }
            if (!(agenda = this.buildMemoryDeltas()).isEmpty()) {
                this.activationManager.onAgenda(ctx.incrementFireCount(), agenda);
                for (RuntimeRule candidate : agenda) {
                    RuntimeRuleImpl rule = (RuntimeRuleImpl)candidate;
                    if (!this.activationManager.test(candidate)) continue;
                    this.activationManager.onActivation(rule, rule.executeRhs());
                    int deltaOperations = this.deltaMemoryManager.deltaOperations();
                    if (deltaOperations > 0) {
                        bufferProcessed = false;
                        break;
                    }
                    this.processBuffer();
                }
                this.commitRuleDeltas();
            }
            this.commitBuffer();
        }
    }

    private void processBuffer() {
        MemoryDeltaTask deltaTask = new MemoryDeltaTask(this.memory.iterator());
        this.getExecutor().invoke(deltaTask);
        this.deltaMemoryManager.onDelete(deltaTask.getDeleteMask());
        this.deltaMemoryManager.onInsert(deltaTask.getInsertMask());
        this.deltaMemoryManager.clearBufferData();
    }

    private List<RuntimeRule> buildMemoryDeltas() {
        LinkedList<RuntimeRule> affectedRules = new LinkedList<RuntimeRule>();
        HashSet<BetaEndNode> affectedEndNodes = new HashSet<BetaEndNode>();
        Mask<MemoryAddress> matchMask = this.deltaMemoryManager.getInsertDeltaMask();
        for (RuntimeRuleImpl rule : this.ruleStorage) {
            boolean ruleAdded = false;
            for (RhsFactGroup group : rule.getLhs().getFactGroups()) {
                if (!matchMask.intersects(group.getMemoryMask())) continue;
                if (!ruleAdded) {
                    affectedRules.add(rule);
                    ruleAdded = true;
                }
                if (!(group instanceof BetaEndNode)) continue;
                affectedEndNodes.add((BetaEndNode)group);
            }
        }
        LinkedList<RuleMemoryInsertTask> tasks = new LinkedList<RuleMemoryInsertTask>();
        if (!affectedEndNodes.isEmpty()) {
            tasks.add(new RuleMemoryInsertTask(affectedEndNodes, matchMask, true));
        }
        if (tasks.size() > 0) {
            ForkJoinExecutor executor = this.getExecutor();
            for (Completer completer : tasks) {
                executor.invoke(completer);
            }
        }
        this.deltaMemoryManager.clearDeltaData();
        return affectedRules;
    }

    private void purge() {
        Mask<MemoryAddress> factPurgeMask = this.deltaMemoryManager.getDeleteDeltaMask();
        if (factPurgeMask.cardinality() > 0) {
            ForkJoinExecutor executor = this.getExecutor();
            MemoryPurgeTask purgeTask = new MemoryPurgeTask(this.memory, factPurgeMask);
            executor.invoke(purgeTask);
            Mask<MemoryAddress> emptyKeysMask = purgeTask.getKeyPurgeMask();
            if (emptyKeysMask.cardinality() > 0) {
                executor.invoke(new ConditionMemoryPurgeTask(this.ruleStorage, emptyKeysMask));
            }
            this.deltaMemoryManager.clearDeleteData();
        }
    }

    private void commitBuffer() {
        this.memory.commitBuffer();
    }

    private void commitRuleDeltas() {
        for (RuntimeRuleImpl rule : this.ruleStorage) {
            rule.commitDeltas();
        }
    }

    @Override
    public S setExecutionPredicate(BooleanSupplier criteria) {
        this.applyFireCriteria(criteria);
        return this.thisInstance();
    }

    @Override
    public final ActivationManager getActivationManager() {
        return this.activationManager;
    }

    private boolean fireCriteriaMet() {
        return this.fireCriteria.getAsBoolean();
    }

    private void applyFireCriteria(BooleanSupplier fireCriteria) {
        this.fireCriteria = fireCriteria;
    }

    private S applyActivationManager1(ActivationManager activationManager) {
        this.activationManager = activationManager;
        return this.thisInstance();
    }

    private void reSortRules() {
        this.ruleStorage.sort(this.getRuleComparator());
    }

    @Override
    public RuntimeRule compileRule(RuleBuilder<?> builder) {
        RuleDescriptor rd = this.compileRuleBuilder(builder);
        return this.deployRule(rd, true);
    }

    @Override
    public final RuntimeRule getRule(String name) {
        return (RuntimeRule)this.ruleStorage.get(name);
    }

    @Override
    public List<RuntimeRule> getRules() {
        return Collections.unmodifiableList(this.ruleStorage.getList());
    }

    @Override
    public void setRuleComparator(Comparator<Rule> ruleComparator) {
        super.setRuleComparator(ruleComparator);
        this.reSortRules();
    }

    private synchronized RuntimeRule deployRule(RuleDescriptor descriptor, boolean hotDeployment) {
        for (FactType factType : descriptor.getLhs().getFactTypes()) {
            TypeMemory tm = this.memory.getCreateUpdate(factType.type());
            tm.touchMemory(factType.getMemoryAddress());
        }
        RuntimeRuleImpl rule = this.ruleStorage.addRule(descriptor, this);
        if (hotDeployment) {
            this.getExecutor().invoke(new RuleHotDeploymentTask(rule));
        }
        this.reSortRules();
        return rule;
    }

    @Override
    public S addEventListener(SessionLifecycleListener listener) {
        this.lifecycleListeners.add(listener);
        return (S)this;
    }

    @Override
    public S removeEventListener(SessionLifecycleListener listener) {
        this.lifecycleListeners.remove(listener);
        return (S)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInner() {
        AbstractRuleSession abstractRuleSession = this;
        synchronized (abstractRuleSession) {
            for (SessionLifecycleListener e : this.lifecycleListeners) {
                e.onEvent(SessionLifecycleListener.Event.PRE_CLOSE);
            }
            this.invalidateSession();
            this.knowledge.close(this);
        }
    }

    private void invalidateSession() {
        this.active = false;
        this.memory.destroy();
    }

    @Override
    public Knowledge getParentContext() {
        return this.knowledge;
    }

    @Override
    void _assertActive() {
        if (!this.active) {
            throw new IllegalStateException("Session has been closed");
        }
    }

    public final SessionMemory getMemory() {
        return this.memory;
    }

    @Override
    public final FactHandle insert(Object fact) {
        this._assertActive();
        return this.insert(this.getTypeResolver().resolve(fact), fact);
    }

    @Override
    public final FactHandle insert(String type, Object fact) {
        this._assertActive();
        return this.insert(this.getTypeResolver().getType(type), fact);
    }

    <T> T getFactInner(FactHandle handle) {
        return (T)this.memory.get(handle.getTypeId()).getFact(handle);
    }

    private FactHandle insert(Type<?> type, Object fact) {
        if (fact == null) {
            throw new NullPointerException("Null facts are not supported");
        }
        if (type == null) {
            if (this.warnUnknownTypes) {
                LOGGER.warning("Can not resolve type for " + fact + ", insert operation skipped.");
            }
            return null;
        }
        return this.memory.get(type).externalInsert(fact);
    }

    final void updateInner(FactHandle handle, Object newValue) {
        this._assertActive();
        if (handle == null) {
            throw new NullPointerException("Null handle provided during update");
        }
        this.memory.get(handle.getTypeId()).add(Action.UPDATE, handle, new FactRecord(newValue));
    }

    final void deleteInner(FactHandle handle) {
        this._assertActive();
        this.memory.get(handle.getTypeId()).add(Action.RETRACT, handle, null);
    }

    final void forEachFactInner(BiConsumer<FactHandle, Object> consumer) {
        for (TypeMemory tm : this.memory) {
            tm.forEachFact(consumer);
        }
    }

    <T> void forEachFactInner(String type, Consumer<T> consumer) {
        Type t = this.getTypeResolver().getType(type);
        if (t == null) {
            throw new IllegalArgumentException("Type not found: '" + type + "'");
        }
        this.memory.getCreateUpdate(t.getId()).forEachFact((handle, o) -> consumer.accept(o));
    }

    @Override
    public void onNewActiveField(ActiveField newField) {
        this.memory.onNewActiveField(newField);
    }

    @Override
    public final void onNewAlphaBucket(MemoryAddress address) {
        this.memory.onNewAlphaBucket(address);
    }

    void clearInner() {
        for (RuntimeRuleImpl rule : this.ruleStorage) {
            rule.clear();
        }
        this.memory.clear();
    }
}

